/*****************************************************************************
-  \file : iap2_parameter_parsing.c
-  \version : $Id: iap2_parameter_parsing.c, v Exp $
-  \release : $Name:$
-  Contains the source code implementation of Parsing of iAP2 Messages from Apple Device
-  \component :
-  \author : Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
-  \copyright (c) 2010 - 2016 Advanced Driver Information Technology.
-  This code is developed by Advanced Driver Information Technology.
-  Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
-  All rights reserved.
-  CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
-           DO NOT CHANGE THE CODE MANUALLY
*****************************************************************************/

#include "iap2_parameter_parsing.h"
#include "iap2_dlt_log.h"
#include "iap2_utility.h"

#define IAP2_MSG_PARAMETER_HEADER_LENGTH  4
#define IAP2_PAR_DATA_OFFSET              4

S32 iAP2ParseiAP2AuthenticationFailedParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of AuthenticationFailedParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2AuthenticationSucceededParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of AuthenticationSucceededParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2RequestAuthenticationCertificateParameter(iAP2RequestAuthenticationCertificateParameter* theiAP2RequestAuthenticationCertificateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    (void)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_REQUEST_AUTHENTICATION_CERTIFICATE_SERIAL_NUMBER_0xAA00:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2RequestAuthenticationCertificateSerialNumber may occur no more than once, all further occurences are ignored
                    if(theiAP2RequestAuthenticationCertificateParameter->iAP2RequestAuthenticationCertificateSerialNumber_count == 0)
                    {
                        theiAP2RequestAuthenticationCertificateParameter->iAP2RequestAuthenticationCertificateSerialNumber_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2RequestAuthenticationCertificateParameter->iAP2RequestAuthenticationCertificateSerialNumber_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RequestAuthenticationCertificateSerialNumber count = %d", theiAP2RequestAuthenticationCertificateParameter->iAP2RequestAuthenticationCertificateSerialNumber_count);
        /* As parameter iAP2RequestAuthenticationCertificateSerialNumber is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_REQUEST_AUTHENTICATION_CERTIFICATE_SERIAL_NUMBER_0xAA00:
                {
                    // iAP2RequestAuthenticationCertificateSerialNumber (U8 none [0..1] 0)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2RequestAuthenticationChallengeResponseParameter(iAP2RequestAuthenticationChallengeResponseParameter* theiAP2RequestAuthenticationChallengeResponseParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_AUTHENTICATION_CHALLENGE_0xAA02:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AuthenticationChallenge may occur no more than once, all further occurences are ignored
                    if(theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count == 0)
                    {
                        theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AuthenticationChallenge count = %d", theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_AUTHENTICATION_CHALLENGE_0xAA02:
                {
                    // iAP2AuthenticationChallenge (iAP2Blob blob [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge[theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2RequestAuthenticationChallengeResponseParameter->iAP2AuthenticationChallenge_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2IdentificationAcceptedParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of IdentificationAcceptedParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2IdentificationRejectedParameter(iAP2IdentificationRejectedParameter* theiAP2IdentificationRejectedParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AccessoryFirmwareVersion may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AccessoryFirmwareVersion_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AccessoryFirmwareVersion_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AccessoryHardwareVersion may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AccessoryHardwareVersion_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AccessoryHardwareVersion_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AccessoryManufacturer may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AccessoryManufacturer_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AccessoryManufacturer_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AccessoryModelIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AccessoryModelIdentifier_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AccessoryModelIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_NAME_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AccessoryName may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AccessoryName_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AccessoryName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AccessorySerialNumber may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AccessorySerialNumber_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AccessorySerialNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_APP_MATCH_TEAM_ID_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2AppMatchTeamID may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2AppMatchTeamID_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2AppMatchTeamID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_HID_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothHIDComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2BluetoothHIDComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2BluetoothHIDComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothTransportComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2BluetoothTransportComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2BluetoothTransportComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2CurrentLanguage may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2CurrentLanguage_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2CurrentLanguage_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_I_AP2HIDCOMPONENT_0x1D03:
                {
                    theiAP2IdentificationRejectedParameter->iAP2iAP2HIDComponent_count++;
                    break;
                }

                case IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2LocationInformationComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2LocationInformationComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2LocationInformationComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_DEVICE_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2MaximumCurrentDrawnFromDevice may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2MaximumCurrentDrawnFromDevice_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2MaximumCurrentDrawnFromDevice_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MESSAGES_RECIEVEDFROM_DEVICE_0x1D03:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MessagesRecievedfromDevice may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MESSAGES_SENT_BY_ACCESSORY_0x1D03:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MessagesSentByAccessory may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_POWER_PROVIDING_CAPABILITY_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2PowerProvidingCapability may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2PowerProvidingCapability_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2PowerProvidingCapability_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERIAL_TRANSPORT_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2SerialTransportComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2SerialTransportComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2SerialTransportComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SUPPORTED_EXTERNAL_ACCESSORY_PROTOCOL_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2SupportedExternalAccessoryProtocol may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2SupportedExternalAccessoryProtocol_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2SupportedExternalAccessoryProtocol_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SUPPORTED_LANGUAGE_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2SupportedLanguage may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2SupportedLanguage_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2SupportedLanguage_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_USB_DEVICE_TRANSPORT_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2USBDeviceTransportComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2USBDeviceTransportComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2USBDeviceTransportComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_USB_HOST_HIDCOMPONENT_0x1D03:
                {
                    theiAP2IdentificationRejectedParameter->iAP2USBHostHIDComponent_count++;
                    break;
                }

                case IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2USBHostTransportComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2USBHostTransportComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2USBHostTransportComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_INFORMATION_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2VehicleInformationComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2VehicleInformationComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2VehicleInformationComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_STATUS_COMPONENT_0x1D03:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2VehicleStatusComponent may occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2VehicleStatusComponent_count == 0)
                    {
                        theiAP2IdentificationRejectedParameter->iAP2VehicleStatusComponent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_WIRELESS_CAR_PLAY_TRANSPORT_COMPONENT_0x1D03:
                {
                    theiAP2IdentificationRejectedParameter->iAP2WirelessCarPlayTransportComponent_count++;
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_0x1D03:
                {
                    theiAP2IdentificationRejectedParameter->iAP2RouteGuidanceDisplayComponent_count++;
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2IdentificationRejectedParameter->iAP2AccessoryFirmwareVersion_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessoryFirmwareVersion count = %d", theiAP2IdentificationRejectedParameter->iAP2AccessoryFirmwareVersion_count);
        /* As parameter iAP2AccessoryFirmwareVersion is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2AccessoryHardwareVersion_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessoryHardwareVersion count = %d", theiAP2IdentificationRejectedParameter->iAP2AccessoryHardwareVersion_count);
        /* As parameter iAP2AccessoryHardwareVersion is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2AccessoryManufacturer_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessoryManufacturer count = %d", theiAP2IdentificationRejectedParameter->iAP2AccessoryManufacturer_count);
        /* As parameter iAP2AccessoryManufacturer is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2AccessoryModelIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessoryModelIdentifier count = %d", theiAP2IdentificationRejectedParameter->iAP2AccessoryModelIdentifier_count);
        /* As parameter iAP2AccessoryModelIdentifier is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2AccessoryName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessoryName count = %d", theiAP2IdentificationRejectedParameter->iAP2AccessoryName_count);
        /* As parameter iAP2AccessoryName is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2AccessorySerialNumber_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessorySerialNumber count = %d", theiAP2IdentificationRejectedParameter->iAP2AccessorySerialNumber_count);
        /* As parameter iAP2AccessorySerialNumber is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2AppMatchTeamID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AppMatchTeamID count = %d", theiAP2IdentificationRejectedParameter->iAP2AppMatchTeamID_count);
        /* As parameter iAP2AppMatchTeamID is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2BluetoothHIDComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothHIDComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2BluetoothHIDComponent_count);
        /* As parameter iAP2BluetoothHIDComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2BluetoothTransportComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothTransportComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2BluetoothTransportComponent_count);
        /* As parameter iAP2BluetoothTransportComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2CurrentLanguage_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CurrentLanguage count = %d", theiAP2IdentificationRejectedParameter->iAP2CurrentLanguage_count);
        /* As parameter iAP2CurrentLanguage is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2iAP2HIDComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2iAP2HIDComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2iAP2HIDComponent_count);
        /* As parameter iAP2iAP2HIDComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2LocationInformationComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2LocationInformationComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2LocationInformationComponent_count);
        /* As parameter iAP2LocationInformationComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2MaximumCurrentDrawnFromDevice_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MaximumCurrentDrawnFromDevice count = %d", theiAP2IdentificationRejectedParameter->iAP2MaximumCurrentDrawnFromDevice_count);
        /* As parameter iAP2MaximumCurrentDrawnFromDevice is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MessagesRecievedfromDevice count = %d", theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MessagesSentByAccessory count = %d", theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2PowerProvidingCapability_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PowerProvidingCapability count = %d", theiAP2IdentificationRejectedParameter->iAP2PowerProvidingCapability_count);
        /* As parameter iAP2PowerProvidingCapability is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2SerialTransportComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SerialTransportComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2SerialTransportComponent_count);
        /* As parameter iAP2SerialTransportComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2SupportedExternalAccessoryProtocol_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SupportedExternalAccessoryProtocol count = %d", theiAP2IdentificationRejectedParameter->iAP2SupportedExternalAccessoryProtocol_count);
        /* As parameter iAP2SupportedExternalAccessoryProtocol is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2SupportedLanguage_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SupportedLanguage count = %d", theiAP2IdentificationRejectedParameter->iAP2SupportedLanguage_count);
        /* As parameter iAP2SupportedLanguage is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2USBDeviceTransportComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBDeviceTransportComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2USBDeviceTransportComponent_count);
        /* As parameter iAP2USBDeviceTransportComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2USBHostHIDComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBHostHIDComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2USBHostHIDComponent_count);
        /* As parameter iAP2USBHostHIDComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2USBHostTransportComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBHostTransportComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2USBHostTransportComponent_count);
        /* As parameter iAP2USBHostTransportComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2VehicleInformationComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleInformationComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2VehicleInformationComponent_count);
        /* As parameter iAP2VehicleInformationComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2VehicleStatusComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleStatusComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2VehicleStatusComponent_count);
        /* As parameter iAP2VehicleStatusComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2WirelessCarPlayTransportComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2WirelessCarPlayTransportComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2WirelessCarPlayTransportComponent_count);
        /* As parameter iAP2WirelessCarPlayTransportComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2IdentificationRejectedParameter->iAP2RouteGuidanceDisplayComponent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceDisplayComponent count = %d", theiAP2IdentificationRejectedParameter->iAP2RouteGuidanceDisplayComponent_count);
        /* As parameter iAP2RouteGuidanceDisplayComponent is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D03:
                {
                    // iAP2AccessoryFirmwareVersion (U8 none [0..1] 4)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D03:
                {
                    // iAP2AccessoryHardwareVersion (U8 none [0..1] 5)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D03:
                {
                    // iAP2AccessoryManufacturer (U8 none [0..1] 2)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D03:
                {
                    // iAP2AccessoryModelIdentifier (U8 none [0..1] 1)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_NAME_0x1D03:
                {
                    // iAP2AccessoryName (U8 none [0..1] 0)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D03:
                {
                    // iAP2AccessorySerialNumber (U8 none [0..1] 3)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_APP_MATCH_TEAM_ID_0x1D03:
                {
                    // iAP2AppMatchTeamID (U8 none [0..1] 11)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    /* Update the count value for the DeprecatedParameter alone */
                    theiAP2IdentificationRejectedParameter->iAP2PreferredAppBundleSeedIdentifier_count = theiAP2IdentificationRejectedParameter->iAP2AppMatchTeamID_count;
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_HID_COMPONENT_0x1D03:
                {
                    // iAP2BluetoothHIDComponent (U8 none [0..1] 29)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_0x1D03:
                {
                    // iAP2BluetoothTransportComponent (U8 none [0..1] 17)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D03:
                {
                    // iAP2CurrentLanguage (U8 none [0..1] 12)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_I_AP2HIDCOMPONENT_0x1D03:
                {
                    // iAP2iAP2HIDComponent (U8 none [0..n] 18)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_0x1D03:
                {
                    // iAP2LocationInformationComponent (U8 none [0..1] 22)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_DEVICE_0x1D03:
                {
                    // iAP2MaximumCurrentDrawnFromDevice (U8 none [0..1] 9)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_MESSAGES_RECIEVEDFROM_DEVICE_0x1D03:
                {
                    // iAP2MessagesRecievedfromDevice (iAP2Blob blob [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice[theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2IdentificationRejectedParameter->iAP2MessagesRecievedfromDevice_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MESSAGES_SENT_BY_ACCESSORY_0x1D03:
                {
                    // iAP2MessagesSentByAccessory (iAP2Blob blob [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory[theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2IdentificationRejectedParameter->iAP2MessagesSentByAccessory_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_POWER_PROVIDING_CAPABILITY_0x1D03:
                {
                    // iAP2PowerProvidingCapability (U8 none [0..1] 8)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    /* Update the count value for the DeprecatedParameter alone */
                    theiAP2IdentificationRejectedParameter->iAP2PowerSourceType_count = theiAP2IdentificationRejectedParameter->iAP2PowerProvidingCapability_count;
                    break;
                }

                case IAP2_PAR_ID_SERIAL_TRANSPORT_COMPONENT_0x1D03:
                {
                    // iAP2SerialTransportComponent (U8 none [0..1] 14)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_SUPPORTED_EXTERNAL_ACCESSORY_PROTOCOL_0x1D03:
                {
                    // iAP2SupportedExternalAccessoryProtocol (U8 none [0..1] 10)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_SUPPORTED_LANGUAGE_0x1D03:
                {
                    // iAP2SupportedLanguage (U8 none [0..1] 13)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_USB_DEVICE_TRANSPORT_COMPONENT_0x1D03:
                {
                    // iAP2USBDeviceTransportComponent (U8 none [0..1] 15)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_USB_HOST_HIDCOMPONENT_0x1D03:
                {
                    // iAP2USBHostHIDComponent (U8 none [0..n] 23)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_0x1D03:
                {
                    // iAP2USBHostTransportComponent (U8 none [0..1] 16)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_INFORMATION_COMPONENT_0x1D03:
                {
                    // iAP2VehicleInformationComponent (U8 none [0..1] 20)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_STATUS_COMPONENT_0x1D03:
                {
                    // iAP2VehicleStatusComponent (U8 none [0..1] 21)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_WIRELESS_CAR_PLAY_TRANSPORT_COMPONENT_0x1D03:
                {
                    // iAP2WirelessCarPlayTransportComponent (U8 none [0..n] 24)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_0x1D03:
                {
                    // iAP2RouteGuidanceDisplayComponent (U8 none [0..n] 30)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StartIdentificationParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of StartIdentificationParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2OOBBTPairingLinkKeyInformationParameter(iAP2OOBBTPairingLinkKeyInformationParameter* theiAP2OOBBTPairingLinkKeyInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_APPLE_DEVICE_MAC_ADDRESS_0x00B2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AppleDeviceMACAddress may occur no more than once, all further occurences are ignored
                    if(theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count == 0)
                    {
                        theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LINK_KEY_0x00B2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2LinkKey may occur no more than once, all further occurences are ignored
                    if(theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count == 0)
                    {
                        theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AppleDeviceMACAddress count = %d", theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count = 0");
    }
    if( (theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2LinkKey count = %d", theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_APPLE_DEVICE_MAC_ADDRESS_0x00B2:
                {
                    // iAP2AppleDeviceMACAddress (iAP2Blob blob [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress[theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2AppleDeviceMACAddress_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LINK_KEY_0x00B2:
                {
                    // iAP2LinkKey (iAP2Blob blob [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey[theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2OOBBTPairingLinkKeyInformationParameter->iAP2LinkKey_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StartOOBBTPairingParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of StartOOBBTPairingParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2StopOOBBTPairingParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of StopOOBBTPairingParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2RouteGuidanceManeuverUpdateParameter(iAP2RouteGuidanceManeuverUpdateParameter* theiAP2RouteGuidanceManeuverUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5202:
                {
                    theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count++;
                    break;
                }

                case IAP2_PAR_ID_INDEX_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Index may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MANEUVER_DESCRIPTION_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ManeuverDescription may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MANEUVER_TYPE_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ManeuverType may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_AFTER_MANEUVER_ROAD_NAME_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AfterManeuverRoadName may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceBetweenManeuver may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_DISPLAY_STR_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceBetweenManeuverDisplayStr may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_DISPLAY_UNITS_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceBetweenManeuverDisplayUnits may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DRIVING_SIDE_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DrivingSide may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_JUNCTION_TYPE_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2JunctionType may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_JUNCTION_ELEMENT_ANGLE_0x5202:
                {
                    theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle_count++;
                    break;
                }

                case IAP2_PAR_ID_JUNCTION_ELEMENT_EXIT_ANGLE_0x5202:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2JunctionElementExitAngle may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count == 0)
                    {
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceDisplayComponentID count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Index count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count = 0");
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ManeuverDescription count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ManeuverType count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count,
                                        sizeof(iAP2ManeuverType),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AfterManeuverRoadName count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceBetweenManeuver count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceBetweenManeuverDisplayStr count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceBetweenManeuverDisplayUnits count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count,
                                        sizeof(iAP2DistanceDisplayUnits),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DrivingSide count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count,
                                        sizeof(iAP2DrivingSide),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2JunctionType count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count,
                                        sizeof(iAP2JunctionType),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2JunctionElementAngle count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle_count,
                                        sizeof(S16),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2JunctionElementExitAngle count = %d", theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count,
                                        sizeof(S16),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5202:
                {
                    // iAP2RouteGuidanceDisplayComponentID (U16 uint16 [0..n] 0)
                    rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count],
                                      &p_SourceBuffer[currentPosition],
                                      currentLength,
                                      iAP2_uint16);
                    theiAP2RouteGuidanceManeuverUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count++;
                    break;
                }

                case IAP2_PAR_ID_INDEX_0x5202:
                {
                    // iAP2Index (U16 uint16 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2Index_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MANEUVER_DESCRIPTION_0x5202:
                {
                    // iAP2ManeuverDescription (U8 utf8 [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverDescription_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MANEUVER_TYPE_0x5202:
                {
                    // iAP2ManeuverType (iAP2ManeuverType enum [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2ManeuverType_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_AFTER_MANEUVER_ROAD_NAME_0x5202:
                {
                    // iAP2AfterManeuverRoadName (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2AfterManeuverRoadName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_0x5202:
                {
                    // iAP2DistanceBetweenManeuver (U32 uint32 [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint32);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuver_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_DISPLAY_STR_0x5202:
                {
                    // iAP2DistanceBetweenManeuverDisplayStr (U8 utf8 [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayStr_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_DISPLAY_UNITS_0x5202:
                {
                    // iAP2DistanceBetweenManeuverDisplayUnits (iAP2DistanceDisplayUnits enum [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DistanceBetweenManeuverDisplayUnits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DRIVING_SIDE_0x5202:
                {
                    // iAP2DrivingSide (iAP2DrivingSide enum [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2DrivingSide_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_JUNCTION_TYPE_0x5202:
                {
                    // iAP2JunctionType (iAP2JunctionType enum [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionType_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_JUNCTION_ELEMENT_ANGLE_0x5202:
                {
                    // iAP2JunctionElementAngle (S16 int16 [0..n] 10)
                    rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle_count],
                                      &p_SourceBuffer[currentPosition],
                                      currentLength,
                                      iAP2_int16);
                    theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementAngle_count++;
                    break;
                }

                case IAP2_PAR_ID_JUNCTION_ELEMENT_EXIT_ANGLE_0x5202:
                {
                    // iAP2JunctionElementExitAngle (S16 int16 [0..1] 11), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle[theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_int16);
                        theiAP2RouteGuidanceManeuverUpdateParameter->iAP2JunctionElementExitAngle_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2RouteGuidanceUpdateParameter(iAP2RouteGuidanceUpdateParameter* theiAP2RouteGuidanceUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5201:
                {
                    theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count++;
                    break;
                }

                case IAP2_PAR_ID_CURRENT_ROAD_NAME_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CurrentRoadName may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DESTINATION_NAME_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DestinationName may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ESTIMATED_TIME_OF_ARRIVAL_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2EstimatedTimeOfArrival may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TIME_REMAINING_TO_DESTINATION_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TimeRemainingToDestination may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_REMAINING_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceRemaining may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_REMAINING_DISPLAY_STR_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceRemainingDisplayStr may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceToNextManeuver may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_DISPLAY_STR_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceToNextManeuverDisplayStr may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_DISPLAY_UNITS_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceToNextManeuverDisplayUnits may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_REMAINING_DISPLAY_UNITS_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DistanceRemainingDisplayUnits may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_STATE_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RouteGuidanceState may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MANEUVER_STATE_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ManeuverState may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_MANEUVER_CURRENT_LIST_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RouteGuidanceManeuverCurrentList may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_MANEUVER_COUNT_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RouteGuidanceManeuverCount may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_VISIBLELN_APP_0x5201:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RouteGuidanceVisiblelnApp may occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count == 0)
                    {
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceDisplayComponentID count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CurrentRoadName count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DestinationName count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2EstimatedTimeOfArrival count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TimeRemainingToDestination count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceRemaining count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceRemainingDisplayStr count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceToNextManeuver count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceToNextManeuverDisplayStr count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceToNextManeuverDisplayUnits count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count,
                                        sizeof(iAP2DistanceDisplayUnits),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DistanceRemainingDisplayUnits count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count,
                                        sizeof(iAP2DistanceDisplayUnits),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceState count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count,
                                        sizeof(iAP2RouteGuidanceState),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ManeuverState count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count,
                                        sizeof(iAP2ManeuverState),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceManeuverCurrentList count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceManeuverCount count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceVisiblelnApp count = %d", theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count,
                                        sizeof(U8),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5201:
                {
                    // iAP2RouteGuidanceDisplayComponentID (U16 uint16 [0..n] 0)
                    rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID[theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count],
                                      &p_SourceBuffer[currentPosition],
                                      currentLength,
                                      iAP2_uint16);
                    theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count++;
                    break;
                }

                case IAP2_PAR_ID_CURRENT_ROAD_NAME_0x5201:
                {
                    // iAP2CurrentRoadName (U8 utf8 [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName[theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceUpdateParameter->iAP2CurrentRoadName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DESTINATION_NAME_0x5201:
                {
                    // iAP2DestinationName (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName[theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DestinationName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ESTIMATED_TIME_OF_ARRIVAL_0x5201:
                {
                    // iAP2EstimatedTimeOfArrival (U64 uint64 [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival[theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2RouteGuidanceUpdateParameter->iAP2EstimatedTimeOfArrival_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TIME_REMAINING_TO_DESTINATION_0x5201:
                {
                    // iAP2TimeRemainingToDestination (U64 uint64 [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination[theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2RouteGuidanceUpdateParameter->iAP2TimeRemainingToDestination_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_REMAINING_0x5201:
                {
                    // iAP2DistanceRemaining (U32 uint32 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining[theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint32);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemaining_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_REMAINING_DISPLAY_STR_0x5201:
                {
                    // iAP2DistanceRemainingDisplayStr (U8 utf8 [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr[theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayStr_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_0x5201:
                {
                    // iAP2DistanceToNextManeuver (U32 uint32 [0..1] 10), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver[theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint32);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuver_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_DISPLAY_STR_0x5201:
                {
                    // iAP2DistanceToNextManeuverDisplayStr (U8 utf8 [0..1] 11), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr[theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayStr_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_DISPLAY_UNITS_0x5201:
                {
                    // iAP2DistanceToNextManeuverDisplayUnits (iAP2DistanceDisplayUnits enum [0..1] 12), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits[theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceToNextManeuverDisplayUnits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISTANCE_REMAINING_DISPLAY_UNITS_0x5201:
                {
                    // iAP2DistanceRemainingDisplayUnits (iAP2DistanceDisplayUnits enum [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits[theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceUpdateParameter->iAP2DistanceRemainingDisplayUnits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_STATE_0x5201:
                {
                    // iAP2RouteGuidanceState (iAP2RouteGuidanceState enum [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState[theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceState_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MANEUVER_STATE_0x5201:
                {
                    // iAP2ManeuverState (iAP2ManeuverState enum [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState[theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RouteGuidanceUpdateParameter->iAP2ManeuverState_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_MANEUVER_CURRENT_LIST_0x5201:
                {
                    // iAP2RouteGuidanceManeuverCurrentList (iAP2Blob blob [0..1] 13), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList[theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCurrentList_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_MANEUVER_COUNT_0x5201:
                {
                    // iAP2RouteGuidanceManeuverCount (U16 uint16 [0..1] 14), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount[theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceManeuverCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_ROUTE_GUIDANCE_VISIBLELN_APP_0x5201:
                {
                    // iAP2RouteGuidanceVisiblelnApp (U8 bool [0..1] 15), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp[theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2RouteGuidanceUpdateParameter->iAP2RouteGuidanceVisiblelnApp_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2AssistiveTouchInformationParameter(iAP2AssistiveTouchInformationParameter* theiAP2AssistiveTouchInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_IS_ENABLED_0x5403:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // IsEnabled may occur no more than once, all further occurences are ignored
                    if(theiAP2AssistiveTouchInformationParameter->IsEnabled_count == 0)
                    {
                        theiAP2AssistiveTouchInformationParameter->IsEnabled_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2AssistiveTouchInformationParameter->IsEnabled_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "IsEnabled count = %d", theiAP2AssistiveTouchInformationParameter->IsEnabled_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2AssistiveTouchInformationParameter->IsEnabled,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2AssistiveTouchInformationParameter->IsEnabled_count,
                                        sizeof(U8),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2AssistiveTouchInformationParameter->IsEnabled_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_IS_ENABLED_0x5403:
                {
                    // IsEnabled (U8 bool [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2AssistiveTouchInformationParameter->IsEnabled_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2AssistiveTouchInformationParameter->IsEnabled[theiAP2AssistiveTouchInformationParameter->IsEnabled_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2AssistiveTouchInformationParameter->IsEnabled_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2BluetoothConnectionUpdateParameter(iAP2BluetoothConnectionUpdateParameter* theiAP2BluetoothConnectionUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_BLUETOOTH_COMPONENT_PROFILES_0x4E04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2BluetoothComponentProfiles may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count == 0)
                    {
                        theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x4E04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2BluetoothTransportComponentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count == 0)
                    {
                        theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothComponentProfiles count = %d", theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count,
                                        sizeof(iAP2BluetoothComponentProfiles),
                                        TRUE);
    }
    if( (theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothTransportComponentIdentifier count = %d", theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_BLUETOOTH_COMPONENT_PROFILES_0x4E04:
                {
                    // iAP2BluetoothComponentProfiles (iAP2BluetoothComponentProfiles group [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count == 0)
                    {
                        rc = iAP2ParseiAP2BluetoothComponentProfiles(&theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles[theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count],
                                                                     &p_SourceBuffer[currentPosition],
                                                                     currentLength,
                                                                     iAP2BufferPool,
                                                                     &iAP2BufferPool_WrPtr);
                        theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x4E04:
                {
                    // iAP2BluetoothTransportComponentIdentifier (U16 uint16 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier[theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothTransportComponentIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2CallStateUpdateParameter(iAP2CallStateUpdateParameter* theiAP2CallStateUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ADDRESS_BOOK_ID_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AddressBookID may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2AddressBookID_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2AddressBookID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_UUID_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CallUUID may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2CallUUID_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2CallUUID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CONFERENCE_GROUP_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ConferenceGroup may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DIRECTION_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Direction may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Direction_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2Direction_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISCONNECT_REASON_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DisconnectReason may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISPLAY_NAME_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DisplayName may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2DisplayName_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2DisplayName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_IS_CONFERENCED_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2IsConferenced may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2IsConferenced_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2IsConferenced_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LABEL_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Label may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Label_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2Label_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REMOTE_ID_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RemoteID may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2RemoteID_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2RemoteID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERVICE_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Service may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Service_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2Service_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_STATUS_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Status may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Status_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2Status_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_START_TIMESTAMP_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2StartTimestamp may occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count == 0)
                    {
                        theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2CallStateUpdateParameter->iAP2AddressBookID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AddressBookID count = %d", theiAP2CallStateUpdateParameter->iAP2AddressBookID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2AddressBookID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2AddressBookID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2CallUUID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallUUID count = %d", theiAP2CallStateUpdateParameter->iAP2CallUUID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2CallUUID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2CallUUID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ConferenceGroup count = %d", theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2ConferenceGroup,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2Direction_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Direction count = %d", theiAP2CallStateUpdateParameter->iAP2Direction_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2Direction,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2Direction_count,
                                        sizeof(iAP2CallStateUpdateDirection),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DisconnectReason count = %d", theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2DisconnectReason,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count,
                                        sizeof(iAP2CallStateUpdateDisconnectReason),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2DisplayName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DisplayName count = %d", theiAP2CallStateUpdateParameter->iAP2DisplayName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2DisplayName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2DisplayName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2IsConferenced_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2IsConferenced count = %d", theiAP2CallStateUpdateParameter->iAP2IsConferenced_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2IsConferenced,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2IsConferenced_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2Label_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Label count = %d", theiAP2CallStateUpdateParameter->iAP2Label_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2Label,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2Label_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2RemoteID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RemoteID count = %d", theiAP2CallStateUpdateParameter->iAP2RemoteID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2RemoteID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2RemoteID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2Service_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Service count = %d", theiAP2CallStateUpdateParameter->iAP2Service_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2Service,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2Service_count,
                                        sizeof(iAP2CallStateUpdateService),
                                        FALSE);
    }
    if( (theiAP2CallStateUpdateParameter->iAP2Status_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Status count = %d", theiAP2CallStateUpdateParameter->iAP2Status_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2Status,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2Status_count,
                                        sizeof(iAP2CallStateUpdateStatus),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2CallStateUpdateParameter->iAP2Status_count = 0");
    }
    if( (theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartTimestamp count = %d", theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CallStateUpdateParameter->iAP2StartTimestamp,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count,
                                        sizeof(U64),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ADDRESS_BOOK_ID_0x4155:
                {
                    // iAP2AddressBookID (U8 utf8 [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2AddressBookID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2AddressBookID[theiAP2CallStateUpdateParameter->iAP2AddressBookID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2CallStateUpdateParameter->iAP2AddressBookID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_UUID_0x4155:
                {
                    // iAP2CallUUID (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2CallUUID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2CallUUID[theiAP2CallStateUpdateParameter->iAP2CallUUID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2CallStateUpdateParameter->iAP2CallUUID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CONFERENCE_GROUP_0x4155:
                {
                    // iAP2ConferenceGroup (U8 uint8 [0..1] 10), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2ConferenceGroup[theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2CallStateUpdateParameter->iAP2ConferenceGroup_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DIRECTION_0x4155:
                {
                    // iAP2Direction (iAP2CallStateUpdateDirection enum [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Direction_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2Direction[theiAP2CallStateUpdateParameter->iAP2Direction_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2CallStateUpdateParameter->iAP2Direction_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISCONNECT_REASON_0x4155:
                {
                    // iAP2DisconnectReason (iAP2CallStateUpdateDisconnectReason enum [0..1] 11), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2DisconnectReason[theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2CallStateUpdateParameter->iAP2DisconnectReason_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISPLAY_NAME_0x4155:
                {
                    // iAP2DisplayName (U8 utf8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2DisplayName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2DisplayName[theiAP2CallStateUpdateParameter->iAP2DisplayName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2CallStateUpdateParameter->iAP2DisplayName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_IS_CONFERENCED_0x4155:
                {
                    // iAP2IsConferenced (U8 bool [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2IsConferenced_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2IsConferenced[theiAP2CallStateUpdateParameter->iAP2IsConferenced_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CallStateUpdateParameter->iAP2IsConferenced_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LABEL_0x4155:
                {
                    // iAP2Label (U8 utf8 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Label_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2Label[theiAP2CallStateUpdateParameter->iAP2Label_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2CallStateUpdateParameter->iAP2Label_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REMOTE_ID_0x4155:
                {
                    // iAP2RemoteID (U8 utf8 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2RemoteID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2RemoteID[theiAP2CallStateUpdateParameter->iAP2RemoteID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2CallStateUpdateParameter->iAP2RemoteID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERVICE_0x4155:
                {
                    // iAP2Service (iAP2CallStateUpdateService enum [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Service_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2Service[theiAP2CallStateUpdateParameter->iAP2Service_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2CallStateUpdateParameter->iAP2Service_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_STATUS_0x4155:
                {
                    // iAP2Status (iAP2CallStateUpdateStatus enum [1..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2Status_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2Status[theiAP2CallStateUpdateParameter->iAP2Status_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2CallStateUpdateParameter->iAP2Status_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_START_TIMESTAMP_0x4155:
                {
                    // iAP2StartTimestamp (U64 uint64 [0..1] 12), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CallStateUpdateParameter->iAP2StartTimestamp[theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2CallStateUpdateParameter->iAP2StartTimestamp_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2CommunicationsUpdateParameter(iAP2CommunicationsUpdateParameter* theiAP2CommunicationsUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_AIRPLANE_MODE_STATUS_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AirplaneModeStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CARRIER_NAME_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CarrierName may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CELLULAR_SUPPORTED_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CellularSupported may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CURRENT_CALL_COUNT_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CurrentCallCount may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_END_AND_ACCEPT_AVAILABLE_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2EndAndAcceptAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FACE_TIME_AUDIO_ENABLED_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2FaceTimeAudioEnabled may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FACE_TIME_VIDEO_ENABLED_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2FaceTimeVideoEnabled may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_HOLD_AND_ACCEPT_AVAILABLE_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2HoldAndAcceptAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_HOLD_AVAILABLE_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2HoldAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INITIATE_CALL_AVAILABLE_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2InitiateCallAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MERGE_AVAILABLE_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MergeAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MUTE_STATUS_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MuteStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_NEW_VOICEMAIL_COUNT_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2NewVoicemailCount may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REGISTRATION_STATUS_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RegistrationStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SIGNAL_STRENGTH_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2SignalStrength may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SWAP_AVAILABLE_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2SwapAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_ENABLED_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TelephonyEnabled may occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count == 0)
                    {
                        theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AirplaneModeStatus count = %d", theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CarrierName count = %d", theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2CarrierName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CellularSupported count = %d", theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2CellularSupported,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CurrentCallCount count = %d", theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2EndAndAcceptAvailable count = %d", theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2FaceTimeAudioEnabled count = %d", theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2FaceTimeVideoEnabled count = %d", theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2HoldAndAcceptAvailable count = %d", theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2HoldAvailable count = %d", theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2InitiateCallAvailable count = %d", theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MergeAvailable count = %d", theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MuteStatus count = %d", theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2MuteStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2NewVoicemailCount count = %d", theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RegistrationStatus count = %d", theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count,
                                        sizeof(iAP2CommunicationsUpdateRegistrationStatus),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SignalStrength count = %d", theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2SignalStrength,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count,
                                        sizeof(iAP2CommunicationsUpdateSignalStrength),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SwapAvailable count = %d", theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyEnabled count = %d", theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count,
                                        sizeof(U8),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_AIRPLANE_MODE_STATUS_0x4158:
                {
                    // iAP2AirplaneModeStatus (U8 bool [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus[theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2AirplaneModeStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CARRIER_NAME_0x4158:
                {
                    // iAP2CarrierName (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2CarrierName[theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2CommunicationsUpdateParameter->iAP2CarrierName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CELLULAR_SUPPORTED_0x4158:
                {
                    // iAP2CellularSupported (U8 bool [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2CellularSupported[theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2CellularSupported_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CURRENT_CALL_COUNT_0x4158:
                {
                    // iAP2CurrentCallCount (U8 uint8 [0..1] 10), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount[theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2CommunicationsUpdateParameter->iAP2CurrentCallCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_END_AND_ACCEPT_AVAILABLE_0x4158:
                {
                    // iAP2EndAndAcceptAvailable (U8 bool [0..1] 13), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable[theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2EndAndAcceptAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FACE_TIME_AUDIO_ENABLED_0x4158:
                {
                    // iAP2FaceTimeAudioEnabled (U8 bool [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled[theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2FaceTimeAudioEnabled_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FACE_TIME_VIDEO_ENABLED_0x4158:
                {
                    // iAP2FaceTimeVideoEnabled (U8 bool [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled[theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2FaceTimeVideoEnabled_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_HOLD_AND_ACCEPT_AVAILABLE_0x4158:
                {
                    // iAP2HoldAndAcceptAvailable (U8 bool [0..1] 14), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable[theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2HoldAndAcceptAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_HOLD_AVAILABLE_0x4158:
                {
                    // iAP2HoldAvailable (U8 bool [0..1] 17), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable[theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2HoldAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INITIATE_CALL_AVAILABLE_0x4158:
                {
                    // iAP2InitiateCallAvailable (U8 bool [0..1] 12), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable[theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2InitiateCallAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MERGE_AVAILABLE_0x4158:
                {
                    // iAP2MergeAvailable (U8 bool [0..1] 16), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable[theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2MergeAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MUTE_STATUS_0x4158:
                {
                    // iAP2MuteStatus (U8 bool [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2MuteStatus[theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2MuteStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_NEW_VOICEMAIL_COUNT_0x4158:
                {
                    // iAP2NewVoicemailCount (U8 uint8 [0..1] 11), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount[theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2CommunicationsUpdateParameter->iAP2NewVoicemailCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REGISTRATION_STATUS_0x4158:
                {
                    // iAP2RegistrationStatus (iAP2CommunicationsUpdateRegistrationStatus enum [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus[theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2CommunicationsUpdateParameter->iAP2RegistrationStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SIGNAL_STRENGTH_0x4158:
                {
                    // iAP2SignalStrength (iAP2CommunicationsUpdateSignalStrength enum [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2SignalStrength[theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2CommunicationsUpdateParameter->iAP2SignalStrength_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SWAP_AVAILABLE_0x4158:
                {
                    // iAP2SwapAvailable (U8 bool [0..1] 15), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable[theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2SwapAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_ENABLED_0x4158:
                {
                    // iAP2TelephonyEnabled (U8 bool [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled[theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2CommunicationsUpdateParameter->iAP2TelephonyEnabled_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2ListUpdateParameter(iAP2ListUpdateParameter* theiAP2ListUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_FAVORITES_LIST_0x4171:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2FavoritesList may occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2FavoritesList_count == 0)
                    {
                        theiAP2ListUpdateParameter->iAP2FavoritesList_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FAVORITES_LIST_AVAILABLE_0x4171:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2FavoritesListAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count == 0)
                    {
                        theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FAVORITES_LIST_COUNT_0x4171:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2FavoritesListCount may occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2FavoritesListCount_count == 0)
                    {
                        theiAP2ListUpdateParameter->iAP2FavoritesListCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECENTS_LIST_0x4171:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RecentsList may occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2RecentsList_count == 0)
                    {
                        theiAP2ListUpdateParameter->iAP2RecentsList_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECENTS_LIST_AVAILABLE_0x4171:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RecentsListAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count == 0)
                    {
                        theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECENTS_LIST_COUNT_0x4171:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RecentsListCount may occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2RecentsListCount_count == 0)
                    {
                        theiAP2ListUpdateParameter->iAP2RecentsListCount_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2ListUpdateParameter->iAP2FavoritesList_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2FavoritesList count = %d", theiAP2ListUpdateParameter->iAP2FavoritesList_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2ListUpdateParameter->iAP2FavoritesList,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2ListUpdateParameter->iAP2FavoritesList_count,
                                        sizeof(iAP2FavoritesList),
                                        TRUE);
    }
    if( (theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2FavoritesListAvailable count = %d", theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2ListUpdateParameter->iAP2FavoritesListAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2ListUpdateParameter->iAP2FavoritesListCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2FavoritesListCount count = %d", theiAP2ListUpdateParameter->iAP2FavoritesListCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2ListUpdateParameter->iAP2FavoritesListCount,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2ListUpdateParameter->iAP2FavoritesListCount_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2ListUpdateParameter->iAP2RecentsList_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RecentsList count = %d", theiAP2ListUpdateParameter->iAP2RecentsList_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2ListUpdateParameter->iAP2RecentsList,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2ListUpdateParameter->iAP2RecentsList_count,
                                        sizeof(iAP2RecentsList),
                                        TRUE);
    }
    if( (theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RecentsListAvailable count = %d", theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2ListUpdateParameter->iAP2RecentsListAvailable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2ListUpdateParameter->iAP2RecentsListCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RecentsListCount count = %d", theiAP2ListUpdateParameter->iAP2RecentsListCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2ListUpdateParameter->iAP2RecentsListCount,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2ListUpdateParameter->iAP2RecentsListCount_count,
                                        sizeof(U16),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_FAVORITES_LIST_0x4171:
                {
                    // iAP2FavoritesList (iAP2FavoritesList group [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2FavoritesList_count == 0)
                    {
                        rc = iAP2ParseiAP2FavoritesList(&theiAP2ListUpdateParameter->iAP2FavoritesList[theiAP2ListUpdateParameter->iAP2FavoritesList_count],
                                                        &p_SourceBuffer[currentPosition],
                                                        currentLength,
                                                        iAP2BufferPool,
                                                        &iAP2BufferPool_WrPtr);
                        theiAP2ListUpdateParameter->iAP2FavoritesList_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FAVORITES_LIST_AVAILABLE_0x4171:
                {
                    // iAP2FavoritesListAvailable (U8 bool [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2ListUpdateParameter->iAP2FavoritesListAvailable[theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2ListUpdateParameter->iAP2FavoritesListAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_FAVORITES_LIST_COUNT_0x4171:
                {
                    // iAP2FavoritesListCount (U16 uint16 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2FavoritesListCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2ListUpdateParameter->iAP2FavoritesListCount[theiAP2ListUpdateParameter->iAP2FavoritesListCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2ListUpdateParameter->iAP2FavoritesListCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECENTS_LIST_0x4171:
                {
                    // iAP2RecentsList (iAP2RecentsList group [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2RecentsList_count == 0)
                    {
                        rc = iAP2ParseiAP2RecentsList(&theiAP2ListUpdateParameter->iAP2RecentsList[theiAP2ListUpdateParameter->iAP2RecentsList_count],
                                                      &p_SourceBuffer[currentPosition],
                                                      currentLength,
                                                      iAP2BufferPool,
                                                      &iAP2BufferPool_WrPtr);
                        theiAP2ListUpdateParameter->iAP2RecentsList_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECENTS_LIST_AVAILABLE_0x4171:
                {
                    // iAP2RecentsListAvailable (U8 bool [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2ListUpdateParameter->iAP2RecentsListAvailable[theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2ListUpdateParameter->iAP2RecentsListAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECENTS_LIST_COUNT_0x4171:
                {
                    // iAP2RecentsListCount (U16 uint16 [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2ListUpdateParameter->iAP2RecentsListCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2ListUpdateParameter->iAP2RecentsListCount[theiAP2ListUpdateParameter->iAP2RecentsListCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2ListUpdateParameter->iAP2RecentsListCount_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceAuthenticationCertificateParameter(iAP2DeviceAuthenticationCertificateParameter* theiAP2DeviceAuthenticationCertificateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DEVICE_CERTIFICATE_0xAA11:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DeviceCertificate may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count == 0)
                    {
                        theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceCertificate count = %d", theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DEVICE_CERTIFICATE_0xAA11:
                {
                    // iAP2DeviceCertificate (iAP2Blob blob [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate[theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2DeviceAuthenticationCertificateParameter->iAP2DeviceCertificate_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceAuthenticationResponseParameter(iAP2DeviceAuthenticationResponseParameter* theiAP2DeviceAuthenticationResponseParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_CHALLENGE_RESPONSE_0xAA13:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ChallengeResponse may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count == 0)
                    {
                        theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ChallengeResponse count = %d", theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_CHALLENGE_RESPONSE_0xAA13:
                {
                    // iAP2ChallengeResponse (iAP2Blob blob [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse[theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2DeviceAuthenticationResponseParameter->iAP2ChallengeResponse_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceInformationUpdateParameter(iAP2DeviceInformationUpdateParameter* theiAP2DeviceInformationUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DEVICE_NAME_0x4E09:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DeviceName may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count == 0)
                    {
                        theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceName count = %d", theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceInformationUpdateParameter->iAP2DeviceName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DEVICE_NAME_0x4E09:
                {
                    // iAP2DeviceName (U8 utf8 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceInformationUpdateParameter->iAP2DeviceName[theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2DeviceInformationUpdateParameter->iAP2DeviceName_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceLanguageUpdateParameter(iAP2DeviceLanguageUpdateParameter* theiAP2DeviceLanguageUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DEVICE_NAME_0x4E0A:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DeviceName may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count == 0)
                    {
                        theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceName count = %d", theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DEVICE_NAME_0x4E0A:
                {
                    // iAP2DeviceName (U8 utf8 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName[theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2DeviceLanguageUpdateParameter->iAP2DeviceName_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceTimeUpdateParameter(iAP2DeviceTimeUpdateParameter* theiAP2DeviceTimeUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DAYLIGHT_SAVINGS_OFFSET_MINUTES_0x4E0B:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DaylightSavingsOffsetMinutes may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count == 0)
                    {
                        theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SECONDS_SINCE_REFERENCE_DATE_0x4E0B:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2SecondsSinceReferenceDate may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count == 0)
                    {
                        theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TIME_ZONE_OFFSET_MINUTES_0x4E0B:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TimeZoneOffsetMinutes may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count == 0)
                    {
                        theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DaylightSavingsOffsetMinutes count = %d", theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count,
                                        sizeof(S8),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count = 0");
    }
    if( (theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SecondsSinceReferenceDate count = %d", theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count,
                                        sizeof(U64),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count = 0");
    }
    if( (theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TimeZoneOffsetMinutes count = %d", theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count,
                                        sizeof(S16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_DAYLIGHT_SAVINGS_OFFSET_MINUTES_0x4E0B:
                {
                    // iAP2DaylightSavingsOffsetMinutes (S8 int8 [1..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes[theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_int8);
                        theiAP2DeviceTimeUpdateParameter->iAP2DaylightSavingsOffsetMinutes_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SECONDS_SINCE_REFERENCE_DATE_0x4E0B:
                {
                    // iAP2SecondsSinceReferenceDate (U64 secs64 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate[theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_secs64);
                        theiAP2DeviceTimeUpdateParameter->iAP2SecondsSinceReferenceDate_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TIME_ZONE_OFFSET_MINUTES_0x4E0B:
                {
                    // iAP2TimeZoneOffsetMinutes (S16 int16 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes[theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_int16);
                        theiAP2DeviceTimeUpdateParameter->iAP2TimeZoneOffsetMinutes_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceTransportIdentifierNotificationParameter(iAP2DeviceTransportIdentifierNotificationParameter* theiAP2DeviceTransportIdentifierNotificationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_BLUETOOTH_TRANSPORT_IDENTIFIER_0x4E0E:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2BluetoothTransportIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count == 0)
                    {
                        theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_USB_TRANSPORT_IDENTIFIER_0x4E0E:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2USBTransportIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count == 0)
                    {
                        theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothTransportIdentifier count = %d", theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBTransportIdentifier count = %d", theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_BLUETOOTH_TRANSPORT_IDENTIFIER_0x4E0E:
                {
                    // iAP2BluetoothTransportIdentifier (U8 utf8 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier[theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2DeviceTransportIdentifierNotificationParameter->iAP2BluetoothTransportIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_USB_TRANSPORT_IDENTIFIER_0x4E0E:
                {
                    // iAP2USBTransportIdentifier (U8 utf8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier[theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2DeviceTransportIdentifierNotificationParameter->iAP2USBTransportIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceUUIDUpdateParameter(iAP2DeviceUUIDUpdateParameter* theiAP2DeviceUUIDUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_UUID_0x4E0C:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2UUID may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count == 0)
                    {
                        theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2UUID count = %d", theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceUUIDUpdateParameter->iAP2UUID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceUUIDUpdateParameter->iAP2UUID_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_UUID_0x4E0C:
                {
                    // iAP2UUID (U8 utf8 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceUUIDUpdateParameter->iAP2UUID[theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2DeviceUUIDUpdateParameter->iAP2UUID_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2WirelessCarPlayUpdateParameter(iAP2WirelessCarPlayUpdateParameter* theiAP2WirelessCarPlayUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_STATUS_0x4E0D:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Status may occur no more than once, all further occurences are ignored
                    if(theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count == 0)
                    {
                        theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Status count = %d", theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2WirelessCarPlayUpdateParameter->iAP2Status,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count,
                                        sizeof(iAP2WirelessCarPlayUpdateStatus),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2WirelessCarPlayUpdateParameter->iAP2Status_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_STATUS_0x4E0D:
                {
                    // iAP2Status (iAP2WirelessCarPlayUpdateStatus enum [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2WirelessCarPlayUpdateParameter->iAP2Status[theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2WirelessCarPlayUpdateParameter->iAP2Status_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StartExternalAccessoryProtocolSessionParameter(iAP2StartExternalAccessoryProtocolSessionParameter* theiAP2StartExternalAccessoryProtocolSessionParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_EXTERNAL_ACCESORY_PROTOCOL_IDENTIFIER_0xEA00:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ExternalAccesoryProtocolIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count == 0)
                    {
                        theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA00:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ExternalAccessoryProtocolSessionIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count == 0)
                    {
                        theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ExternalAccesoryProtocolIdentifier count = %d", theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count,
                                        sizeof(U8),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count = 0");
    }
    if( (theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ExternalAccessoryProtocolSessionIdentifier count = %d", theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_EXTERNAL_ACCESORY_PROTOCOL_IDENTIFIER_0xEA00:
                {
                    // iAP2ExternalAccesoryProtocolIdentifier (U8 uint8 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier[theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccesoryProtocolIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA00:
                {
                    // iAP2ExternalAccessoryProtocolSessionIdentifier (U16 uint16 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier[theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2StartExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StopExternalAccessoryProtocolSessionParameter(iAP2StopExternalAccessoryProtocolSessionParameter* theiAP2StopExternalAccessoryProtocolSessionParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2ExternalAccessoryProtocolSessionIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count == 0)
                    {
                        theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ExternalAccessoryProtocolSessionIdentifier count = %d", theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA01:
                {
                    // iAP2ExternalAccessoryProtocolSessionIdentifier (U16 uint16 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier[theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2StopExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2DeviceHIDReportParameter(iAP2DeviceHIDReportParameter* theiAP2DeviceHIDReportParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6801:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2HIDComponentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count == 0)
                    {
                        theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_HID_REPORT_0x6801:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2HIDReport may occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceHIDReportParameter->iAP2HIDReport_count == 0)
                    {
                        theiAP2DeviceHIDReportParameter->iAP2HIDReport_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2HIDComponentIdentifier count = %d", theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count = 0");
    }
    if( (theiAP2DeviceHIDReportParameter->iAP2HIDReport_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2HIDReport count = %d", theiAP2DeviceHIDReportParameter->iAP2HIDReport_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2DeviceHIDReportParameter->iAP2HIDReport,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2DeviceHIDReportParameter->iAP2HIDReport_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2DeviceHIDReportParameter->iAP2HIDReport_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6801:
                {
                    // iAP2HIDComponentIdentifier (U16 uint16 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier[theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2DeviceHIDReportParameter->iAP2HIDComponentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_HID_REPORT_0x6801:
                {
                    // iAP2HIDReport (iAP2Blob blob [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2DeviceHIDReportParameter->iAP2HIDReport_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2DeviceHIDReportParameter->iAP2HIDReport[theiAP2DeviceHIDReportParameter->iAP2HIDReport_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2DeviceHIDReportParameter->iAP2HIDReport_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StartNativeHIDParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of StartNativeHIDParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2GPRMCDataStatusValuesNotificationParameter(iAP2GPRMCDataStatusValuesNotificationParameter* theiAP2GPRMCDataStatusValuesNotificationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    (void)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_A_0xFFF0:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2GPRMCDataStatusValueA may occur no more than once, all further occurences are ignored
                    if(theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueA_count == 0)
                    {
                        theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueA_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_V_0xFFF0:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2GPRMCDataStatusValueV may occur no more than once, all further occurences are ignored
                    if(theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueV_count == 0)
                    {
                        theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueV_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_X_0xFFF0:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2GPRMCDataStatusValueX may occur no more than once, all further occurences are ignored
                    if(theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueX_count == 0)
                    {
                        theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueX_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueA_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2GPRMCDataStatusValueA count = %d", theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueA_count);
        /* As parameter iAP2GPRMCDataStatusValueA is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueV_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2GPRMCDataStatusValueV count = %d", theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueV_count);
        /* As parameter iAP2GPRMCDataStatusValueV is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueX_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2GPRMCDataStatusValueX count = %d", theiAP2GPRMCDataStatusValuesNotificationParameter->iAP2GPRMCDataStatusValueX_count);
        /* As parameter iAP2GPRMCDataStatusValueX is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_A_0xFFF0:
                {
                    // iAP2GPRMCDataStatusValueA (U8 none [0..1] 0)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_V_0xFFF0:
                {
                    // iAP2GPRMCDataStatusValueV (U8 none [0..1] 1)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_X_0xFFF0:
                {
                    // iAP2GPRMCDataStatusValueX (U8 none [0..1] 2)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StartLocationInformationParameter(iAP2StartLocationInformationParameter* theiAP2StartLocationInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    (void)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_GLOBAL_POSITIONING_SYSTEM_FIX_DATA_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2GlobalPositioningSystemFixData may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2GlobalPositioningSystemFixData_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2GlobalPositioningSystemFixData_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_GPS_SATELLITES_IN_VIEW_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2GPSSatellitesInView may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2GPSSatellitesInView_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2GPSSatellitesInView_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RECOMMENDED_MINIMUM_SPECIFIC_GPS_TRANSIT_DATA_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2RecommendedMinimumSpecificGPSTransitData may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2RecommendedMinimumSpecificGPSTransitData_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2RecommendedMinimumSpecificGPSTransitData_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_ACCELEROMETER_DATA_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2VehicleAccelerometerData may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2VehicleAccelerometerData_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2VehicleAccelerometerData_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_GYRO_DATA_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2VehicleGyroData may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2VehicleGyroData_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2VehicleGyroData_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_HEADING_DATA_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2VehicleHeadingData may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2VehicleHeadingData_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2VehicleHeadingData_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_SPEED_DATA_0xFFFA:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2VehicleSpeedData may occur no more than once, all further occurences are ignored
                    if(theiAP2StartLocationInformationParameter->iAP2VehicleSpeedData_count == 0)
                    {
                        theiAP2StartLocationInformationParameter->iAP2VehicleSpeedData_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2StartLocationInformationParameter->iAP2GlobalPositioningSystemFixData_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2GlobalPositioningSystemFixData count = %d", theiAP2StartLocationInformationParameter->iAP2GlobalPositioningSystemFixData_count);
        /* As parameter iAP2GlobalPositioningSystemFixData is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartLocationInformationParameter->iAP2GPSSatellitesInView_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2GPSSatellitesInView count = %d", theiAP2StartLocationInformationParameter->iAP2GPSSatellitesInView_count);
        /* As parameter iAP2GPSSatellitesInView is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartLocationInformationParameter->iAP2RecommendedMinimumSpecificGPSTransitData_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RecommendedMinimumSpecificGPSTransitData count = %d", theiAP2StartLocationInformationParameter->iAP2RecommendedMinimumSpecificGPSTransitData_count);
        /* As parameter iAP2RecommendedMinimumSpecificGPSTransitData is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartLocationInformationParameter->iAP2VehicleAccelerometerData_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleAccelerometerData count = %d", theiAP2StartLocationInformationParameter->iAP2VehicleAccelerometerData_count);
        /* As parameter iAP2VehicleAccelerometerData is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartLocationInformationParameter->iAP2VehicleGyroData_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleGyroData count = %d", theiAP2StartLocationInformationParameter->iAP2VehicleGyroData_count);
        /* As parameter iAP2VehicleGyroData is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartLocationInformationParameter->iAP2VehicleHeadingData_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleHeadingData count = %d", theiAP2StartLocationInformationParameter->iAP2VehicleHeadingData_count);
        /* As parameter iAP2VehicleHeadingData is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartLocationInformationParameter->iAP2VehicleSpeedData_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleSpeedData count = %d", theiAP2StartLocationInformationParameter->iAP2VehicleSpeedData_count);
        /* As parameter iAP2VehicleSpeedData is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_GLOBAL_POSITIONING_SYSTEM_FIX_DATA_0xFFFA:
                {
                    // iAP2GlobalPositioningSystemFixData (U8 none [0..1] 1)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_GPS_SATELLITES_IN_VIEW_0xFFFA:
                {
                    // iAP2GPSSatellitesInView (U8 none [0..1] 3)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_RECOMMENDED_MINIMUM_SPECIFIC_GPS_TRANSIT_DATA_0xFFFA:
                {
                    // iAP2RecommendedMinimumSpecificGPSTransitData (U8 none [0..1] 2)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_ACCELEROMETER_DATA_0xFFFA:
                {
                    // iAP2VehicleAccelerometerData (U8 none [0..1] 6)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_GYRO_DATA_0xFFFA:
                {
                    // iAP2VehicleGyroData (U8 none [0..1] 5)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_HEADING_DATA_0xFFFA:
                {
                    // iAP2VehicleHeadingData (U8 none [0..1] 7)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_VEHICLE_SPEED_DATA_0xFFFA:
                {
                    // iAP2VehicleSpeedData (U8 none [0..1] 4)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StopLocationInformationParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of StopLocationInformationParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2MediaLibraryInformationParameter(iAP2MediaLibraryInformationParameter* theiAP2MediaLibraryInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_LIBRARY_INFORMATION_SUB_PARAMETER_0x4C01:
                {
                    theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count++;
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryInformationSubParameter count = %d", theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count,
                                        sizeof(iAP2MediaLibraryInformationSubParameter),
                                        TRUE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_LIBRARY_INFORMATION_SUB_PARAMETER_0x4C01:
                {
                    // iAP2MediaLibraryInformationSubParameter (iAP2MediaLibraryInformationSubParameter group [0..n] 0)
                    rc = iAP2ParseiAP2MediaLibraryInformationSubParameter(&theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter[theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count],
                                                                          &p_SourceBuffer[currentPosition],
                                                                          currentLength,
                                                                          iAP2BufferPool,
                                                                          &iAP2BufferPool_WrPtr);
                    theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count++;
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2MediaLibraryUpdateParameter(iAP2MediaLibraryUpdateParameter* theiAP2MediaLibraryUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_ITEM_0x4C04:
                {
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_DELETE_PERSISTENT_IDENTIFIER_0x4C04:
                {
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_IS_HIDING_REMOTE_ITEMS_0x4C04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaLibraryIsHidingRemoteItems may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count == 0)
                    {
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_RESET_0x4C04:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2MediaLibraryReset may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryReset_count == 0)
                    {
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryReset_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_REVISION_0x4C04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaLibraryRevision may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count == 0)
                    {
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaLibraryUniqueIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count == 0)
                    {
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_UPDATE_PROGRESS_0x4C04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaLibraryUpdateProgress may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count == 0)
                    {
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAY_LIST_0x4C04:
                {
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_DELETE_PERSISTENT_IDENTIFIER_0x4C04:
                {
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count++;
                    break;
                }

                case IAP2_PAR_ID_PLAY_ALL_SONGS_CAPABLE_0x4C04:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlayAllSongsCapable may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count == 0)
                    {
                        theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItem count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaItem,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count,
                                        sizeof(iAP2MediaItem),
                                        TRUE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemDeletePersistentIdentifier count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryIsHidingRemoteItems count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryReset_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryReset count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryReset_count);
        /* As parameter iAP2MediaLibraryReset is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryRevision count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryUniqueIdentifier count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count = 0");
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryUpdateProgress count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlayList count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count,
                                        sizeof(iAP2MediaPlayList),
                                        TRUE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistDeletePersistentIdentifier count = %d", theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlayAllSongsCapable count = %d", theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count,
                                        sizeof(U8),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_ITEM_0x4C04:
                {
                    // iAP2MediaItem (iAP2MediaItem group [0..n] 2)
                    rc = iAP2ParseiAP2MediaItem(&theiAP2MediaLibraryUpdateParameter->iAP2MediaItem[theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count],
                                                &p_SourceBuffer[currentPosition],
                                                currentLength,
                                                iAP2BufferPool,
                                                &iAP2BufferPool_WrPtr);
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_DELETE_PERSISTENT_IDENTIFIER_0x4C04:
                {
                    // iAP2MediaItemDeletePersistentIdentifier (U64 uint64 [0..n] 4)
                    rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier[theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count],
                                      &p_SourceBuffer[currentPosition],
                                      currentLength,
                                      iAP2_uint64);
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_IS_HIDING_REMOTE_ITEMS_0x4C04:
                {
                    // iAP2MediaLibraryIsHidingRemoteItems (U8 bool [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems[theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryIsHidingRemoteItems_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_RESET_0x4C04:
                {
                    // iAP2MediaLibraryReset (U8 none [0..1] 6)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_REVISION_0x4C04:
                {
                    // iAP2MediaLibraryRevision (U8 utf8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision[theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryRevision_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C04:
                {
                    // iAP2MediaLibraryUniqueIdentifier (U8 utf8 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier[theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUniqueIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_UPDATE_PROGRESS_0x4C04:
                {
                    // iAP2MediaLibraryUpdateProgress (U8 uint8 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress[theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2MediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAY_LIST_0x4C04:
                {
                    // iAP2MediaPlayList (iAP2MediaPlayList group [0..n] 3)
                    rc = iAP2ParseiAP2MediaPlayList(&theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList[theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count],
                                                    &p_SourceBuffer[currentPosition],
                                                    currentLength,
                                                    iAP2BufferPool,
                                                    &iAP2BufferPool_WrPtr);
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_DELETE_PERSISTENT_IDENTIFIER_0x4C04:
                {
                    // iAP2MediaPlaylistDeletePersistentIdentifier (U64 uint64 [0..n] 5)
                    rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier[theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count],
                                      &p_SourceBuffer[currentPosition],
                                      currentLength,
                                      iAP2_uint64);
                    theiAP2MediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count++;
                    break;
                }

                case IAP2_PAR_ID_PLAY_ALL_SONGS_CAPABLE_0x4C04:
                {
                    // iAP2PlayAllSongsCapable (U8 bool [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable[theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaLibraryUpdateParameter->iAP2PlayAllSongsCapable_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2NowPlayingUpdateParameter(iAP2NowPlayingUpdateParameter* theiAP2NowPlayingUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_ITEM_ATTRIBUTES_0x5001:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAttributes may occur no more than once, all further occurences are ignored
                    if(theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count == 0)
                    {
                        theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_ATTRIBUTES_0x5001:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackAttributes may occur no more than once, all further occurences are ignored
                    if(theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count == 0)
                    {
                        theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAttributes count = %d", theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count,
                                        sizeof(iAP2MediaItem),
                                        TRUE);
    }
    if( (theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackAttributes count = %d", theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count,
                                        sizeof(iAP2PlaybackAttributes),
                                        TRUE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_ITEM_ATTRIBUTES_0x5001:
                {
                    // iAP2MediaItemAttributes (iAP2MediaItem group [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count == 0)
                    {
                        rc = iAP2ParseiAP2MediaItem(&theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes[theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count],
                                                    &p_SourceBuffer[currentPosition],
                                                    currentLength,
                                                    iAP2BufferPool,
                                                    &iAP2BufferPool_WrPtr);
                        theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_ATTRIBUTES_0x5001:
                {
                    // iAP2PlaybackAttributes (iAP2PlaybackAttributes group [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count == 0)
                    {
                        rc = iAP2ParseiAP2PlaybackAttributes(&theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes[theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count],
                                                             &p_SourceBuffer[currentPosition],
                                                             currentLength,
                                                             iAP2BufferPool,
                                                             &iAP2BufferPool_WrPtr);
                        theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2PowerUpdateParameter(iAP2PowerUpdateParameter* theiAP2PowerUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ACCESSORY_POWER_MODE_0xAE01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AccessoryPowerMode may occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count == 0)
                    {
                        theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BATTERY_CHARGE_LEVEL_0xAE01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2BatteryChargeLevel may occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count == 0)
                    {
                        theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BATTERY_CHARGING_STATE_0xAE01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2BatteryChargingState may occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count == 0)
                    {
                        theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DEVICE_BATTERY_WILL_CHARGE_IF_POWER_IS_PRESENT_0xAE01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DeviceBatteryWillChargeIfPowerIsPresent may occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count == 0)
                    {
                        theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_IS_EXTERNAL_CHARGER_CONNECTED_0xAE01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2IsExternalChargerConnected may occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count == 0)
                    {
                        theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_ACCESSORY_0xAE01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MaximumCurrentDrawnFromAccessory may occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count == 0)
                    {
                        theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AccessoryPowerMode count = %d", theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count,
                                        sizeof(iAP2AccessoryPowerModes),
                                        FALSE);
    }
    if( (theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BatteryChargeLevel count = %d", theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BatteryChargingState count = %d", theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PowerUpdateParameter->iAP2BatteryChargingState,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count,
                                        sizeof(iAP2BatteryChargingState),
                                        FALSE);
    }
    if( (theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceBatteryWillChargeIfPowerIsPresent count = %d", theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2IsExternalChargerConnected count = %d", theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MaximumCurrentDrawnFromAccessory count = %d", theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count,
                                        sizeof(U16),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ACCESSORY_POWER_MODE_0xAE01:
                {
                    // iAP2AccessoryPowerMode (iAP2AccessoryPowerModes enum [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode[theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2PowerUpdateParameter->iAP2AccessoryPowerMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BATTERY_CHARGE_LEVEL_0xAE01:
                {
                    // iAP2BatteryChargeLevel (U16 uint16 [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel[theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2PowerUpdateParameter->iAP2BatteryChargeLevel_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BATTERY_CHARGING_STATE_0xAE01:
                {
                    // iAP2BatteryChargingState (iAP2BatteryChargingState enum [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PowerUpdateParameter->iAP2BatteryChargingState[theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2PowerUpdateParameter->iAP2BatteryChargingState_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DEVICE_BATTERY_WILL_CHARGE_IF_POWER_IS_PRESENT_0xAE01:
                {
                    // iAP2DeviceBatteryWillChargeIfPowerIsPresent (U8 bool [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent[theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2PowerUpdateParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_IS_EXTERNAL_CHARGER_CONNECTED_0xAE01:
                {
                    // iAP2IsExternalChargerConnected (U8 bool [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected[theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2PowerUpdateParameter->iAP2IsExternalChargerConnected_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_ACCESSORY_0xAE01:
                {
                    // iAP2MaximumCurrentDrawnFromAccessory (U16 uint16 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory[theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2PowerUpdateParameter->iAP2MaximumCurrentDrawnFromAccessory_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2TelephonyCallStateInformationParameter(iAP2TelephonyCallStateInformationParameter* theiAP2TelephonyCallStateInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_CALL_STATE_PHONE_NUMBER_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CallStatePhoneNumber may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count == 0)
                    {
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATE_CALLER_NAME_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CallStateCallerName may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count == 0)
                    {
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATE_STATUS_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CallStateStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count == 0)
                    {
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATE_DIRECTION_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CallStateDirection may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count == 0)
                    {
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_UNIQUE_CALL_ID_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2UniqueCallID may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count == 0)
                    {
                        theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATEV_CARD_FILE_TRANSFER_IDENTIFIER_0x4155:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2CallStatevCardFileTransferIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count == 0)
                    {
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallStatePhoneNumber count = %d", theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count = 0");
    }
    if( (theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallStateCallerName count = %d", theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count = 0");
    }
    if( (theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallStateStatus count = %d", theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count,
                                        sizeof(iAP2CallStateStatusValue),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count = 0");
    }
    if( (theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallStateDirection count = %d", theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count,
                                        sizeof(iAP2CallStateDirectionValue),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count = 0");
    }
    if( (theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2UniqueCallID count = %d", theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallStatevCardFileTransferIdentifier count = %d", theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count,
                                        sizeof(U8),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_CALL_STATE_PHONE_NUMBER_0x4155:
                {
                    // iAP2CallStatePhoneNumber (U8 utf8 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber[theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStatePhoneNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATE_CALLER_NAME_0x4155:
                {
                    // iAP2CallStateCallerName (U8 utf8 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName[theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStateCallerName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATE_STATUS_0x4155:
                {
                    // iAP2CallStateStatus (iAP2CallStateStatusValue enum [1..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus[theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStateStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATE_DIRECTION_0x4155:
                {
                    // iAP2CallStateDirection (iAP2CallStateDirectionValue enum [1..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection[theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStateDirection_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_UNIQUE_CALL_ID_0x4155:
                {
                    // iAP2UniqueCallID (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID[theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2TelephonyCallStateInformationParameter->iAP2UniqueCallID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_CALL_STATEV_CARD_FILE_TRANSFER_IDENTIFIER_0x4155:
                {
                    // iAP2CallStatevCardFileTransferIdentifier (U8 uint8 [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier[theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2TelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2TelephonyUpdateParameter(iAP2TelephonyUpdateParameter* theiAP2TelephonyUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_TELEPHONY_SIGNAL_STRENGTH_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TelephonySignalStrength may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count == 0)
                    {
                        theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_REGISTRATION_STATUS_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TelephonyRegistrationStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count == 0)
                    {
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_AIRPLANE_MODE_STATUS_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TelephonyAirplaneModeStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count == 0)
                    {
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_TTY_STATUS_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TelephonyTTYStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count == 0)
                    {
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_MOBILE_OPERATOR_0x4158:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2TelephonyMobileOperator may occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count == 0)
                    {
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonySignalStrength count = %d", theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count,
                                        sizeof(iAP2TelephonySignalStrengthValue),
                                        FALSE);
    }
    if( (theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyRegistrationStatus count = %d", theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count,
                                        sizeof(iAP2TelephonyRegistrationStatusValue),
                                        FALSE);
    }
    if( (theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyAirplaneModeStatus count = %d", theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyTTYStatus count = %d", theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyMobileOperator count = %d", theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_TELEPHONY_SIGNAL_STRENGTH_0x4158:
                {
                    // iAP2TelephonySignalStrength (iAP2TelephonySignalStrengthValue enum [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength[theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2TelephonyUpdateParameter->iAP2TelephonySignalStrength_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_REGISTRATION_STATUS_0x4158:
                {
                    // iAP2TelephonyRegistrationStatus (iAP2TelephonyRegistrationStatusValue enum [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus[theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyRegistrationStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_AIRPLANE_MODE_STATUS_0x4158:
                {
                    // iAP2TelephonyAirplaneModeStatus (U8 bool [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus[theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyAirplaneModeStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_TTY_STATUS_0x4158:
                {
                    // iAP2TelephonyTTYStatus (U8 bool [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus[theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyTTYStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TELEPHONY_MOBILE_OPERATOR_0x4158:
                {
                    // iAP2TelephonyMobileOperator (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator[theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2TelephonyUpdateParameter->iAP2TelephonyMobileOperator_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2USBDeviceModeAudioInformationParameter(iAP2USBDeviceModeAudioInformationParameter* theiAP2USBDeviceModeAudioInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_SAMPLE_RATE_0xDA01:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2SampleRate may occur no more than once, all further occurences are ignored
                    if(theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count == 0)
                    {
                        theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SampleRate count = %d", theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count,
                                        sizeof(iAP2USBDeviceModeAudioSampleRate),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count = 0");
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_SAMPLE_RATE_0xDA01:
                {
                    // iAP2SampleRate (iAP2USBDeviceModeAudioSampleRate enum [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate[theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2USBDeviceModeAudioInformationParameter->iAP2SampleRate_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StartVehicleStatusUpdatesParameter(iAP2StartVehicleStatusUpdatesParameter* theiAP2StartVehicleStatusUpdatesParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    (void)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_NIGHT_MODE_0xA100:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2NightMode may occur no more than once, all further occurences are ignored
                    if(theiAP2StartVehicleStatusUpdatesParameter->iAP2NightMode_count == 0)
                    {
                        theiAP2StartVehicleStatusUpdatesParameter->iAP2NightMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RANGE_0xA100:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2Range may occur no more than once, all further occurences are ignored
                    if(theiAP2StartVehicleStatusUpdatesParameter->iAP2Range_count == 0)
                    {
                        theiAP2StartVehicleStatusUpdatesParameter->iAP2Range_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INSIDE_TEMPERATURE_0xA100:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2InsideTemperature may occur no more than once, all further occurences are ignored
                    if(theiAP2StartVehicleStatusUpdatesParameter->iAP2InsideTemperature_count == 0)
                    {
                        theiAP2StartVehicleStatusUpdatesParameter->iAP2InsideTemperature_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_OUTSIDE_TEMPERATURE_0xA100:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2OutsideTemperature may occur no more than once, all further occurences are ignored
                    if(theiAP2StartVehicleStatusUpdatesParameter->iAP2OutsideTemperature_count == 0)
                    {
                        theiAP2StartVehicleStatusUpdatesParameter->iAP2OutsideTemperature_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_RANGE_WARNING_0xA100:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2RangeWarning may occur no more than once, all further occurences are ignored
                    if(theiAP2StartVehicleStatusUpdatesParameter->iAP2RangeWarning_count == 0)
                    {
                        theiAP2StartVehicleStatusUpdatesParameter->iAP2RangeWarning_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2StartVehicleStatusUpdatesParameter->iAP2NightMode_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2NightMode count = %d", theiAP2StartVehicleStatusUpdatesParameter->iAP2NightMode_count);
        /* As parameter iAP2NightMode is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartVehicleStatusUpdatesParameter->iAP2Range_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Range count = %d", theiAP2StartVehicleStatusUpdatesParameter->iAP2Range_count);
        /* As parameter iAP2Range is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartVehicleStatusUpdatesParameter->iAP2InsideTemperature_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2InsideTemperature count = %d", theiAP2StartVehicleStatusUpdatesParameter->iAP2InsideTemperature_count);
        /* As parameter iAP2InsideTemperature is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartVehicleStatusUpdatesParameter->iAP2OutsideTemperature_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2OutsideTemperature count = %d", theiAP2StartVehicleStatusUpdatesParameter->iAP2OutsideTemperature_count);
        /* As parameter iAP2OutsideTemperature is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2StartVehicleStatusUpdatesParameter->iAP2RangeWarning_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RangeWarning count = %d", theiAP2StartVehicleStatusUpdatesParameter->iAP2RangeWarning_count);
        /* As parameter iAP2RangeWarning is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_NIGHT_MODE_0xA100:
                {
                    // iAP2NightMode (U8 none [0..1] 2)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_RANGE_0xA100:
                {
                    // iAP2Range (U8 none [0..1] 3)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_INSIDE_TEMPERATURE_0xA100:
                {
                    // iAP2InsideTemperature (U8 none [0..1] 5)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_OUTSIDE_TEMPERATURE_0xA100:
                {
                    // iAP2OutsideTemperature (U8 none [0..1] 4)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_RANGE_WARNING_0xA100:
                {
                    // iAP2RangeWarning (U8 none [0..1] 6)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2StopVehicleStatusUpdatesParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of StopVehicleStatusUpdatesParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2VoiceOverCursorUpdateParameter(iAP2VoiceOverCursorUpdateParameter* theiAP2VoiceOverCursorUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_VOICE_OVER_HINT_0x5610:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverHint may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count == 0)
                    {
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_LABEL_0x5610:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverLabel may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count == 0)
                    {
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_TRAITS_0x5610:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverTraits may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count == 0)
                    {
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_VALUE_0x5610:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverValue may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count == 0)
                    {
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverHint count = %d", theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverLabel count = %d", theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverTraits count = %d", theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count,
                                        sizeof(iAP2Blob),
                                        FALSE);
    }
    if( (theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverValue count = %d", theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_VOICE_OVER_HINT_0x5610:
                {
                    // iAP2VoiceOverHint (U8 utf8 [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint[theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverHint_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_LABEL_0x5610:
                {
                    // iAP2VoiceOverLabel (U8 utf8 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel[theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverLabel_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_TRAITS_0x5610:
                {
                    // iAP2VoiceOverTraits (iAP2Blob blob [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits[theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_blob);
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverTraits_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_VALUE_0x5610:
                {
                    // iAP2VoiceOverValue (U8 utf8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue[theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2VoiceOverCursorUpdateParameter->iAP2VoiceOverValue_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2VoiceOverUpdateParameter(iAP2VoiceOverUpdateParameter* theiAP2VoiceOverUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_VOICE_OVER_ENABLED_0x560C:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverEnabled may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count == 0)
                    {
                        theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560C:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverSpeakingRate may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count == 0)
                    {
                        theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560C:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2VoiceOverSpeakingVolume may occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count == 0)
                    {
                        theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverEnabled count = %d", theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverSpeakingRate count = %d", theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverSpeakingVolume count = %d", theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count,
                                        sizeof(U8),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_VOICE_OVER_ENABLED_0x560C:
                {
                    // iAP2VoiceOverEnabled (U8 bool [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled[theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2VoiceOverUpdateParameter->iAP2VoiceOverEnabled_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560C:
                {
                    // iAP2VoiceOverSpeakingRate (U8 uint8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate[theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingRate_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560C:
                {
                    // iAP2VoiceOverSpeakingVolume (U8 uint8 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume[theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2VoiceOverUpdateParameter->iAP2VoiceOverSpeakingVolume_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2RequestAccessoryWiFiConfigurationInformationParameter(U16 msgLength)
{
    S32 rc = IAP2_OK;

    if(msgLength != IAP2_MSG_PARAMETER_OFFSET)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Parameters are present as part of RequestAccessoryWiFiConfigurationInformationParameter message from Apple Device, Whereas in EA Model this Parameter is not present kindly check the Specification for any Updates.");
    }
    return rc;
}

S32 iAP2ParseiAP2WiFiInformationParameter(iAP2WiFiInformationParameter* theiAP2WiFiInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    U8* iAP2BufferPool_WrPtr = (U8*)iAP2BufferPool;

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition +=currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_REQUEST_STATUS_0x5701:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RequestStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2WiFiInformationParameter->iAP2RequestStatus_count == 0)
                    {
                        theiAP2WiFiInformationParameter->iAP2RequestStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_WI_FI_SSID_0x5701:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2WiFiSSID may occur no more than once, all further occurences are ignored
                    if(theiAP2WiFiInformationParameter->iAP2WiFiSSID_count == 0)
                    {
                        theiAP2WiFiInformationParameter->iAP2WiFiSSID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_WI_FI_PASSPHRASE_0x5701:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2WiFiPassphrase may occur no more than once, all further occurences are ignored
                    if(theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count == 0)
                    {
                        theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2WiFiInformationParameter->iAP2RequestStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RequestStatus count = %d", theiAP2WiFiInformationParameter->iAP2RequestStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2WiFiInformationParameter->iAP2RequestStatus,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2WiFiInformationParameter->iAP2RequestStatus_count,
                                        sizeof(iAP2WiFiRequestStatus),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2WiFiInformationParameter->iAP2RequestStatus_count = 0");
    }
    if( (theiAP2WiFiInformationParameter->iAP2WiFiSSID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2WiFiSSID count = %d", theiAP2WiFiInformationParameter->iAP2WiFiSSID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2WiFiInformationParameter->iAP2WiFiSSID,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2WiFiInformationParameter->iAP2WiFiSSID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2WiFiPassphrase count = %d", theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2WiFiInformationParameter->iAP2WiFiPassphrase,
                                        iAP2BufferPool,
                                        &iAP2BufferPool_WrPtr,
                                        &theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_MSG_PARAMETER_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= msgLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= msgLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_REQUEST_STATUS_0x5701:
                {
                    // iAP2RequestStatus (iAP2WiFiRequestStatus enum [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2WiFiInformationParameter->iAP2RequestStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2WiFiInformationParameter->iAP2RequestStatus[theiAP2WiFiInformationParameter->iAP2RequestStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2WiFiInformationParameter->iAP2RequestStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_WI_FI_SSID_0x5701:
                {
                    // iAP2WiFiSSID (U8 utf8 [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2WiFiInformationParameter->iAP2WiFiSSID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2WiFiInformationParameter->iAP2WiFiSSID[theiAP2WiFiInformationParameter->iAP2WiFiSSID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2WiFiInformationParameter->iAP2WiFiSSID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_WI_FI_PASSPHRASE_0x5701:
                {
                    // iAP2WiFiPassphrase (U8 utf8 [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2WiFiInformationParameter->iAP2WiFiPassphrase[theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2WiFiInformationParameter->iAP2WiFiPassphrase_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for msgLength %d  at Position %d ID:%d", currentLength,msgLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2BluetoothComponentProfiles(iAP2BluetoothComponentProfiles* theiAP2BluetoothComponentProfiles, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;
    (void)iAP2BufferPool;
    (void)iAP2BufferPool_WrPtr;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_BLUETOOTH_ADVANCED_AUDIO_DISTRIBUTION_PROFILE_SPID_4:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothAdvancedAudioDistributionProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_AUDIO_VIDEO_REMOTECONTROL_PROFILE_SPID_3:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothAudioVideoRemotecontrolProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_HANDS_FREE_PROFILE_SPID_0:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothHandsFreeProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_HUMAN_INTERFACE_DEVICE_PROFILE_SPID_5:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothHumanInterfaceDeviceProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTHI_AP2LINK_PROFILE_SPID_7:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothiAP2LinkProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_MESSAGE_ACCESS_PROFILE_SPID_9:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothMessageAccessProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_PERSONAL_AREA_NETWORK_ACCESS_POINT_PROFILE_SPID_8:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothPersonalAreaNetworkAccessPointProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_PERSONAL_AREA_NETWORK_CLIENT_PROFILE_SPID_12:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothPersonalAreaNetworkClientProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_PHONE_BOOK_ACCESS_PROFILE_SPID_1:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2BluetoothPhoneBookAccessProfile may occur no more than once, all further occurences are ignored
                    if(theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile_count == 0)
                    {
                        theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothAdvancedAudioDistributionProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile_count);
        /* As parameter iAP2BluetoothAdvancedAudioDistributionProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothAudioVideoRemotecontrolProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile_count);
        /* As parameter iAP2BluetoothAudioVideoRemotecontrolProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothHandsFreeProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile_count);
        /* As parameter iAP2BluetoothHandsFreeProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothHumanInterfaceDeviceProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile_count);
        /* As parameter iAP2BluetoothHumanInterfaceDeviceProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothiAP2LinkProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile_count);
        /* As parameter iAP2BluetoothiAP2LinkProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothMessageAccessProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile_count);
        /* As parameter iAP2BluetoothMessageAccessProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothPersonalAreaNetworkAccessPointProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile_count);
        /* As parameter iAP2BluetoothPersonalAreaNetworkAccessPointProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothPersonalAreaNetworkClientProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile_count);
        /* As parameter iAP2BluetoothPersonalAreaNetworkClientProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothPhoneBookAccessProfile count = %d", theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile_count);
        /* As parameter iAP2BluetoothPhoneBookAccessProfile is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_BLUETOOTH_ADVANCED_AUDIO_DISTRIBUTION_PROFILE_SPID_4:
                {
                    // iAP2BluetoothAdvancedAudioDistributionProfile (U8 none [0..1] 4)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_AUDIO_VIDEO_REMOTECONTROL_PROFILE_SPID_3:
                {
                    // iAP2BluetoothAudioVideoRemotecontrolProfile (U8 none [0..1] 3)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_HANDS_FREE_PROFILE_SPID_0:
                {
                    // iAP2BluetoothHandsFreeProfile (U8 none [0..1] 0)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_HUMAN_INTERFACE_DEVICE_PROFILE_SPID_5:
                {
                    // iAP2BluetoothHumanInterfaceDeviceProfile (U8 none [0..1] 5)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTHI_AP2LINK_PROFILE_SPID_7:
                {
                    // iAP2BluetoothiAP2LinkProfile (U8 none [0..1] 7)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_MESSAGE_ACCESS_PROFILE_SPID_9:
                {
                    // iAP2BluetoothMessageAccessProfile (U8 none [0..1] 9)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_PERSONAL_AREA_NETWORK_ACCESS_POINT_PROFILE_SPID_8:
                {
                    // iAP2BluetoothPersonalAreaNetworkAccessPointProfile (U8 none [0..1] 8)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_PERSONAL_AREA_NETWORK_CLIENT_PROFILE_SPID_12:
                {
                    // iAP2BluetoothPersonalAreaNetworkClientProfile (U8 none [0..1] 12)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_BLUETOOTH_PHONE_BOOK_ACCESS_PROFILE_SPID_1:
                {
                    // iAP2BluetoothPhoneBookAccessProfile (U8 none [0..1] 1)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2FavoritesList(iAP2FavoritesList* theiAP2FavoritesList, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AddressBookID may occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2AddressBookID_count == 0)
                    {
                        theiAP2FavoritesList->iAP2AddressBookID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISPLAY_NAME_SPID_2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DisplayName may occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2DisplayName_count == 0)
                    {
                        theiAP2FavoritesList->iAP2DisplayName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INDEX_SPID_0:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Index may occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2Index_count == 0)
                    {
                        theiAP2FavoritesList->iAP2Index_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LABEL_SPID_3:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Label may occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2Label_count == 0)
                    {
                        theiAP2FavoritesList->iAP2Label_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REMOTE_ID_SPID_1:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RemoteID may occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2RemoteID_count == 0)
                    {
                        theiAP2FavoritesList->iAP2RemoteID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERVICE_SPID_5:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Service may occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2Service_count == 0)
                    {
                        theiAP2FavoritesList->iAP2Service_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2FavoritesList->iAP2AddressBookID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AddressBookID count = %d", theiAP2FavoritesList->iAP2AddressBookID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2FavoritesList->iAP2AddressBookID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2FavoritesList->iAP2AddressBookID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2FavoritesList->iAP2DisplayName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DisplayName count = %d", theiAP2FavoritesList->iAP2DisplayName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2FavoritesList->iAP2DisplayName,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2FavoritesList->iAP2DisplayName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2FavoritesList->iAP2DisplayName_count = 0");
    }
    if( (theiAP2FavoritesList->iAP2Index_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Index count = %d", theiAP2FavoritesList->iAP2Index_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2FavoritesList->iAP2Index,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2FavoritesList->iAP2Index_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2FavoritesList->iAP2Index_count = 0");
    }
    if( (theiAP2FavoritesList->iAP2Label_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Label count = %d", theiAP2FavoritesList->iAP2Label_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2FavoritesList->iAP2Label,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2FavoritesList->iAP2Label_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2FavoritesList->iAP2RemoteID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RemoteID count = %d", theiAP2FavoritesList->iAP2RemoteID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2FavoritesList->iAP2RemoteID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2FavoritesList->iAP2RemoteID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2FavoritesList->iAP2RemoteID_count = 0");
    }
    if( (theiAP2FavoritesList->iAP2Service_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Service count = %d", theiAP2FavoritesList->iAP2Service_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2FavoritesList->iAP2Service,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2FavoritesList->iAP2Service_count,
                                        sizeof(iAP2ListUpdateService),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2FavoritesList->iAP2Service_count = 0");
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4:
                {
                    // iAP2AddressBookID (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2AddressBookID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2FavoritesList->iAP2AddressBookID[theiAP2FavoritesList->iAP2AddressBookID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2FavoritesList->iAP2AddressBookID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISPLAY_NAME_SPID_2:
                {
                    // iAP2DisplayName (U8 utf8 [1..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2DisplayName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2FavoritesList->iAP2DisplayName[theiAP2FavoritesList->iAP2DisplayName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2FavoritesList->iAP2DisplayName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INDEX_SPID_0:
                {
                    // iAP2Index (U16 uint16 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2Index_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2FavoritesList->iAP2Index[theiAP2FavoritesList->iAP2Index_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2FavoritesList->iAP2Index_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LABEL_SPID_3:
                {
                    // iAP2Label (U8 utf8 [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2Label_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2FavoritesList->iAP2Label[theiAP2FavoritesList->iAP2Label_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2FavoritesList->iAP2Label_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REMOTE_ID_SPID_1:
                {
                    // iAP2RemoteID (U8 utf8 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2RemoteID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2FavoritesList->iAP2RemoteID[theiAP2FavoritesList->iAP2RemoteID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2FavoritesList->iAP2RemoteID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERVICE_SPID_5:
                {
                    // iAP2Service (iAP2ListUpdateService enum [1..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2FavoritesList->iAP2Service_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2FavoritesList->iAP2Service[theiAP2FavoritesList->iAP2Service_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2FavoritesList->iAP2Service_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2MediaItem(iAP2MediaItem* theiAP2MediaItem, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_SPID_14:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumArtist may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumArtist_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumArtist_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_PERSISTENT_IDENTIFIER_SPID_13:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumArtistPersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_COUNT_SPID_10:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumDiscCount may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_NUMBER_SPID_9:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumDiscNumber may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_PERSISTENT_IDENTIFIER_SPID_5:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumPersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumTitle may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumTitle_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumTitle_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_COUNT_SPID_8:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumTrackCount may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_NUMBER_SPID_7:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemAlbumTrackNumber may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemArtist may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemArtist_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemArtist_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ARTIST_PERSISTENT_IDENTIFIER_SPID_11:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemArtistPersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ARTWORK_FILE_TRANSFER_IDENTIFIER_SPID_26:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemArtworkFileTransferIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_CHAPTER_COUNT_SPID_27:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemChapterCount may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemChapterCount_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemChapterCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemComposer may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemComposer_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemComposer_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_PERSISTENT_IDENTIFIER_SPID_17:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemComposerPersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemGenre may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemGenre_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemGenre_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_GENRE_PERSISTENT_IDENTIFIER_SPID_15:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemGenrePersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_BANNED_SPID_24:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemIsBanned may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsBanned_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemIsBanned_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_BAN_SUPPORTED_SPID_22:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemIsBanSupported may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsBanSupported_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemIsBanSupported_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_LIKED_SPID_23:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemIsLiked may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsLiked_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemIsLiked_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_LIKE_SUPPORTED_SPID_21:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemIsLikeSupported may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_PART_OF_COMPILATION_SPID_19:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemIsPartOfCompilation may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_RESIDENT_ON_DEVICE_SPID_25:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemIsResidentOnDevice may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_MEDIA_TYPE_SPID_2:
                {
                    theiAP2MediaItem->iAP2MediaItemMediaType_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_PERSISTENT_IDENTIFIER_SPID_0:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemPersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemPlaybackDurationInMilliseconds may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_RATING_SPID_3:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemRating may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemRating_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemRating_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaItemTitle may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemTitle_count == 0)
                    {
                        theiAP2MediaItem->iAP2MediaItemTitle_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2MediaItem->iAP2MediaItemAlbumArtist_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumArtist count = %d", theiAP2MediaItem->iAP2MediaItemAlbumArtist_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumArtist,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumArtist_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumArtistPersistentIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumDiscCount count = %d", theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumDiscCount,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumDiscNumber count = %d", theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumPersistentIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumTitle_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumTitle count = %d", theiAP2MediaItem->iAP2MediaItemAlbumTitle_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumTitle,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumTitle_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumTrackCount count = %d", theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumTrackCount,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAlbumTrackNumber count = %d", theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemArtist_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemArtist count = %d", theiAP2MediaItem->iAP2MediaItemArtist_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemArtist,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemArtist_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemArtistPersistentIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemArtworkFileTransferIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemChapterCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemChapterCount count = %d", theiAP2MediaItem->iAP2MediaItemChapterCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemChapterCount,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemChapterCount_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemComposer_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemComposer count = %d", theiAP2MediaItem->iAP2MediaItemComposer_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemComposer,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemComposer_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemComposerPersistentIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemGenre_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemGenre count = %d", theiAP2MediaItem->iAP2MediaItemGenre_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemGenre,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemGenre_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemGenrePersistentIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemIsBanned_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemIsBanned count = %d", theiAP2MediaItem->iAP2MediaItemIsBanned_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemIsBanned,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemIsBanned_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemIsBanSupported_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemIsBanSupported count = %d", theiAP2MediaItem->iAP2MediaItemIsBanSupported_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemIsBanSupported,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemIsBanSupported_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemIsLiked_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemIsLiked count = %d", theiAP2MediaItem->iAP2MediaItemIsLiked_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemIsLiked,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemIsLiked_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemIsLikeSupported count = %d", theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemIsLikeSupported,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemIsPartOfCompilation count = %d", theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemIsResidentOnDevice count = %d", theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemMediaType_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemMediaType count = %d", theiAP2MediaItem->iAP2MediaItemMediaType_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemMediaType,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemMediaType_count,
                                        sizeof(iAP2MediaType),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemPersistentIdentifier count = %d", theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemPersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemPlaybackDurationInMilliseconds count = %d", theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemRating_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemRating count = %d", theiAP2MediaItem->iAP2MediaItemRating_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemRating,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemRating_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaItem->iAP2MediaItemTitle_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemTitle count = %d", theiAP2MediaItem->iAP2MediaItemTitle_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaItem->iAP2MediaItemTitle,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaItem->iAP2MediaItemTitle_count,
                                        sizeof(U8*),
                                        FALSE);
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_SPID_14:
                {
                    // iAP2MediaItemAlbumArtist (U8 utf8 [0..1] 14), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumArtist_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumArtist[theiAP2MediaItem->iAP2MediaItemAlbumArtist_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaItem->iAP2MediaItemAlbumArtist_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_PERSISTENT_IDENTIFIER_SPID_13:
                {
                    // iAP2MediaItemAlbumArtistPersistentIdentifier (U64 uint64 [0..1] 13), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier[theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_COUNT_SPID_10:
                {
                    // iAP2MediaItemAlbumDiscCount (U16 uint16 [0..1] 10), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumDiscCount[theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_NUMBER_SPID_9:
                {
                    // iAP2MediaItemAlbumDiscNumber (U16 uint16 [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber[theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_PERSISTENT_IDENTIFIER_SPID_5:
                {
                    // iAP2MediaItemAlbumPersistentIdentifier (U64 uint64 [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier[theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6:
                {
                    // iAP2MediaItemAlbumTitle (U8 utf8 [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumTitle_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumTitle[theiAP2MediaItem->iAP2MediaItemAlbumTitle_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaItem->iAP2MediaItemAlbumTitle_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_COUNT_SPID_8:
                {
                    // iAP2MediaItemAlbumTrackCount (U16 uint16 [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumTrackCount[theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_NUMBER_SPID_7:
                {
                    // iAP2MediaItemAlbumTrackNumber (U16 uint16 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber[theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12:
                {
                    // iAP2MediaItemArtist (U8 utf8 [0..1] 12), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemArtist_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemArtist[theiAP2MediaItem->iAP2MediaItemArtist_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaItem->iAP2MediaItemArtist_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ARTIST_PERSISTENT_IDENTIFIER_SPID_11:
                {
                    // iAP2MediaItemArtistPersistentIdentifier (U64 uint64 [0..1] 11), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier[theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_ARTWORK_FILE_TRANSFER_IDENTIFIER_SPID_26:
                {
                    // iAP2MediaItemArtworkFileTransferIdentifier (U8 uint8 [0..1] 26), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier[theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_CHAPTER_COUNT_SPID_27:
                {
                    // iAP2MediaItemChapterCount (U16 uint16 [0..1] 27), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemChapterCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemChapterCount[theiAP2MediaItem->iAP2MediaItemChapterCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2MediaItem->iAP2MediaItemChapterCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18:
                {
                    // iAP2MediaItemComposer (U8 utf8 [0..1] 18), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemComposer_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemComposer[theiAP2MediaItem->iAP2MediaItemComposer_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaItem->iAP2MediaItemComposer_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_PERSISTENT_IDENTIFIER_SPID_17:
                {
                    // iAP2MediaItemComposerPersistentIdentifier (U64 uint64 [0..1] 17), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier[theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16:
                {
                    // iAP2MediaItemGenre (U8 utf8 [0..1] 16), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemGenre_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemGenre[theiAP2MediaItem->iAP2MediaItemGenre_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaItem->iAP2MediaItemGenre_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_GENRE_PERSISTENT_IDENTIFIER_SPID_15:
                {
                    // iAP2MediaItemGenrePersistentIdentifier (U64 uint64 [0..1] 15), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier[theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_BANNED_SPID_24:
                {
                    // iAP2MediaItemIsBanned (U8 bool [0..1] 24), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsBanned_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemIsBanned[theiAP2MediaItem->iAP2MediaItemIsBanned_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaItem->iAP2MediaItemIsBanned_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_BAN_SUPPORTED_SPID_22:
                {
                    // iAP2MediaItemIsBanSupported (U8 bool [0..1] 22), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsBanSupported_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemIsBanSupported[theiAP2MediaItem->iAP2MediaItemIsBanSupported_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaItem->iAP2MediaItemIsBanSupported_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_LIKED_SPID_23:
                {
                    // iAP2MediaItemIsLiked (U8 bool [0..1] 23), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsLiked_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemIsLiked[theiAP2MediaItem->iAP2MediaItemIsLiked_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaItem->iAP2MediaItemIsLiked_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_LIKE_SUPPORTED_SPID_21:
                {
                    // iAP2MediaItemIsLikeSupported (U8 bool [0..1] 21), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemIsLikeSupported[theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_PART_OF_COMPILATION_SPID_19:
                {
                    // iAP2MediaItemIsPartOfCompilation (U8 bool [0..1] 19), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation[theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_IS_RESIDENT_ON_DEVICE_SPID_25:
                {
                    // iAP2MediaItemIsResidentOnDevice (U8 bool [0..1] 25), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice[theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_MEDIA_TYPE_SPID_2:
                {
                    // iAP2MediaItemMediaType (iAP2MediaType enum [0..n] 2)
                    rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemMediaType[theiAP2MediaItem->iAP2MediaItemMediaType_count],
                                      &p_SourceBuffer[currentPosition],
                                      currentLength,
                                      iAP2_enum);
                    theiAP2MediaItem->iAP2MediaItemMediaType_count++;
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_PERSISTENT_IDENTIFIER_SPID_0:
                {
                    // iAP2MediaItemPersistentIdentifier (U64 uint64 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemPersistentIdentifier[theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4:
                {
                    // iAP2MediaItemPlaybackDurationInMilliseconds (U32 msecs32 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds[theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_msecs32);
                        theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_RATING_SPID_3:
                {
                    // iAP2MediaItemRating (U8 uint8 [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemRating_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemRating[theiAP2MediaItem->iAP2MediaItemRating_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2MediaItem->iAP2MediaItemRating_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1:
                {
                    // iAP2MediaItemTitle (U8 utf8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaItem->iAP2MediaItemTitle_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaItem->iAP2MediaItemTitle[theiAP2MediaItem->iAP2MediaItemTitle_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaItem->iAP2MediaItemTitle_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2MediaLibraryInformationSubParameter(iAP2MediaLibraryInformationSubParameter* theiAP2MediaLibraryInformationSubParameter, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_LIBRARY_NAME_SPID_0:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaLibraryName may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count == 0)
                    {
                        theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_UNIQUE_IDENTIFIER_SPID_1:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaUniqueIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count == 0)
                    {
                        theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_TYPE_SPID_2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaLibraryType may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count == 0)
                    {
                        theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryName count = %d", theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count = 0");
    }
    if( (theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaUniqueIdentifier count = %d", theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count = 0");
    }
    if( (theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryType count = %d", theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count,
                                        sizeof(iAP2MediaLibraryType),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count = 0");
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_LIBRARY_NAME_SPID_0:
                {
                    // iAP2MediaLibraryName (U8 utf8 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName[theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_UNIQUE_IDENTIFIER_SPID_1:
                {
                    // iAP2MediaUniqueIdentifier (U8 utf8 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier[theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_LIBRARY_TYPE_SPID_2:
                {
                    // iAP2MediaLibraryType (iAP2MediaLibraryType enum [1..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType[theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2MediaPlayList(iAP2MediaPlayList* theiAP2MediaPlayList, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_PLAYLIST_CONTAINED_MEDIA_ITEMS_FILE_TRANSFER_IDENTIFIER_SPID_5:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_IS_APPLE_MUSIC_RADIO_STATION_SPID_6:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistIsAppleMusicRadioStation may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_IS_FOLDER_SPID_4:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistIsFolder may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_IS_GENIUS_MIX_SPID_3:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistIsGeniusMix may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_NAME_SPID_1:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistName may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistName_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_PARENT_PERSISTENT_IDENTIFER_SPID_2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistParentPersistentIdentifer may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_PERSISTENT_IDENTIFIER_SPID_0:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2MediaPlaylistPersistentIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_SPID_7:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2MediaPlaylistContentTransfer may occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer_count == 0)
                    {
                        theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistIsAppleMusicRadioStation count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistIsFolder count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistIsGeniusMix count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistName count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistName,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistParentPersistentIdentifer count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistPersistentIdentifier count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count,
                                        sizeof(U64),
                                        FALSE);
    }
    if( (theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistContentTransfer count = %d", theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer_count);
        /* As parameter iAP2MediaPlaylistContentTransfer is of type - none, Memory Allocation from Buffer Pool is not required */
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_MEDIA_PLAYLIST_CONTAINED_MEDIA_ITEMS_FILE_TRANSFER_IDENTIFIER_SPID_5:
                {
                    // iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier (U8 uint8 [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier[theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_IS_APPLE_MUSIC_RADIO_STATION_SPID_6:
                {
                    // iAP2MediaPlaylistIsAppleMusicRadioStation (U8 bool [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation[theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count++;
                        /* Copy the values to Deprecated parameters as well to support backward compatibility */
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsiTunesRadioStation = theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation;
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsiTunesRadioStation_count = theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_IS_FOLDER_SPID_4:
                {
                    // iAP2MediaPlaylistIsFolder (U8 bool [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder[theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_IS_GENIUS_MIX_SPID_3:
                {
                    // iAP2MediaPlaylistIsGeniusMix (U8 bool [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix[theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_NAME_SPID_1:
                {
                    // iAP2MediaPlaylistName (U8 utf8 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistName[theiAP2MediaPlayList->iAP2MediaPlaylistName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2MediaPlayList->iAP2MediaPlaylistName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_PARENT_PERSISTENT_IDENTIFER_SPID_2:
                {
                    // iAP2MediaPlaylistParentPersistentIdentifer (U64 uint64 [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer[theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_PERSISTENT_IDENTIFIER_SPID_0:
                {
                    // iAP2MediaPlaylistPersistentIdentifier (U64 uint64 [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier[theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_SPID_7:
                {
                    // iAP2MediaPlaylistContentTransfer (U8 none [0..1] 7)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2PlaybackAttributes(iAP2PlaybackAttributes* theiAP2PlaybackAttributes, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_AD_SPID_9:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PBAppleMusicRadioAd may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_STATION_NAME_SPID_10:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PBAppleMusicRadioStationName may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PB_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_SPID_8:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PBMediaLibraryUniqueIdentifier may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_APP_BUNDLE_ID_SPID_16:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackAppBundleID may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_APP_NAME_SPID_7:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackAppName may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackAppName_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackAppName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_ELAPSED_TIME_IN_MILLISECONDS_SPID_1:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackElapsedTimeInMilliseconds may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_CHAPTER_INDEX_SPID_4:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackQueueChapterIndex may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_COUNT_SPID_3:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackQueueCount may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_SPID_2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackQueueIndex may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_AVAIL_SPID_14:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackQueueListAvail may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_TRANSFER_ID_SPID_15:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackQueueListTransferID may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_REPEAT_MODE_SPID_6:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackRepeatMode may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_SHUFFLE_MODE_SPID_5:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackShuffleMode may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_SPEED_SPID_12:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackSpeed may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_STATUS_SPID_0:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PlaybackStatus may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackStatus_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SET_ELAPSED_TIME_AVAILABLE_SPID_13:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2SetElapsedTimeAvailable may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_SPID_17:
                {
                    //for data type none, there won't be any data field so check for data field present or not is not required
                    // iAP2PlaybackQueueListContentTransfer may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PB_APPE_MUSIC_RADIO_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID may occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count == 0)
                    {
                        theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PBAppleMusicRadioAd count = %d", theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PBAppleMusicRadioStationName count = %d", theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PBMediaLibraryUniqueIdentifier count = %d", theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackAppBundleID count = %d", theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackAppName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackAppName count = %d", theiAP2PlaybackAttributes->iAP2PlaybackAppName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackAppName,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackAppName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackElapsedTimeInMilliseconds count = %d", theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueChapterIndex count = %d", theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueCount count = %d", theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackQueueCount,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueIndex count = %d", theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueListAvail count = %d", theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueListTransferID count = %d", theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackRepeatMode count = %d", theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count,
                                        sizeof(iAP2PlaybackRepeat),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackShuffleMode count = %d", theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count,
                                        sizeof(iAP2PlaybackShuffle),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackSpeed count = %d", theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackSpeed,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count,
                                        sizeof(U16),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackStatus_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackStatus count = %d", theiAP2PlaybackAttributes->iAP2PlaybackStatus_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PlaybackStatus,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PlaybackStatus_count,
                                        sizeof(iAP2PlaybackStatus),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SetElapsedTimeAvailable count = %d", theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count,
                                        sizeof(U8),
                                        FALSE);
    }
    if( (theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueListContentTransfer count = %d", theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer_count);
        /* As parameter iAP2PlaybackQueueListContentTransfer is of type - none, Memory Allocation from Buffer Pool is not required */
    }
    if( (theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID count = %d", theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count,
                                        sizeof(U64),
                                        FALSE);
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_AD_SPID_9:
                {
                    // iAP2PBAppleMusicRadioAd (U8 bool [0..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd[theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count++;
                        /* Copy the values to Deprecated parameters as well to support backward compatibility */
                        theiAP2PlaybackAttributes->iAP2PBiTunesRadioAd = theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd;
                        theiAP2PlaybackAttributes->iAP2PBiTunesRadioAd_count = theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count;
                    }
                    break;
                }

                case IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_STATION_NAME_SPID_10:
                {
                    // iAP2PBAppleMusicRadioStationName (U8 utf8 [0..1] 10), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName[theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count++;
                        /* Copy the values to Deprecated parameters as well to support backward compatibility */
                        theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationName = theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName;
                        theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationName_count = theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count;
                    }
                    break;
                }

                case IAP2_PAR_ID_PB_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_SPID_8:
                {
                    // iAP2PBMediaLibraryUniqueIdentifier (U8 utf8 [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier[theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_APP_BUNDLE_ID_SPID_16:
                {
                    // iAP2PlaybackAppBundleID (U8 utf8 [0..1] 16), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID[theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_APP_NAME_SPID_7:
                {
                    // iAP2PlaybackAppName (U8 utf8 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackAppName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackAppName[theiAP2PlaybackAttributes->iAP2PlaybackAppName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2PlaybackAttributes->iAP2PlaybackAppName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_ELAPSED_TIME_IN_MILLISECONDS_SPID_1:
                {
                    // iAP2PlaybackElapsedTimeInMilliseconds (U32 msecs32 [0..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds[theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_msecs32);
                        theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_CHAPTER_INDEX_SPID_4:
                {
                    // iAP2PlaybackQueueChapterIndex (U32 uint32 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex[theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint32);
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_COUNT_SPID_3:
                {
                    // iAP2PlaybackQueueCount (U32 uint32 [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackQueueCount[theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint32);
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_SPID_2:
                {
                    // iAP2PlaybackQueueIndex (U32 uint32 [0..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex[theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint32);
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_AVAIL_SPID_14:
                {
                    // iAP2PlaybackQueueListAvail (U8 bool [0..1] 14), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail[theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_TRANSFER_ID_SPID_15:
                {
                    // iAP2PlaybackQueueListTransferID (U8 uint8 [0..1] 15), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID[theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_REPEAT_MODE_SPID_6:
                {
                    // iAP2PlaybackRepeatMode (iAP2PlaybackRepeat enum [0..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode[theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_SHUFFLE_MODE_SPID_5:
                {
                    // iAP2PlaybackShuffleMode (iAP2PlaybackShuffle enum [0..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode[theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_SPEED_SPID_12:
                {
                    // iAP2PlaybackSpeed (U16 uint16 [0..1] 12), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackSpeed[theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_STATUS_SPID_0:
                {
                    // iAP2PlaybackStatus (iAP2PlaybackStatus enum [0..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PlaybackStatus_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PlaybackStatus[theiAP2PlaybackAttributes->iAP2PlaybackStatus_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2PlaybackAttributes->iAP2PlaybackStatus_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SET_ELAPSED_TIME_AVAILABLE_SPID_13:
                {
                    // iAP2SetElapsedTimeAvailable (U8 bool [0..1] 13), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable[theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_bool);
                        theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_SPID_17:
                {
                    // iAP2PlaybackQueueListContentTransfer (U8 none [0..1] 17)
                    /* Need not update count value for none type, as the count value is not cleared using iAP2AllocateFromBufferPool API */
                    break;
                }

                case IAP2_PAR_ID_PB_APPE_MUSIC_RADIO_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11:
                {
                    // iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID (U64 uint64 [0..1] 11), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID[theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count++;
                        /* Copy the values to Deprecated parameters as well to support backward compatibility */
                        theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationMediaPlaylistPersistentID = theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID;
                        theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationMediaPlaylistPersistentID_count = theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}

S32 iAP2ParseiAP2RecentsList(iAP2RecentsList* theiAP2RecentsList, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr)
{
    S32 rc = IAP2_OK;
    U16 currentID = 0;
    U16 currentLength = 0;
    U16 currentPosition;

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2AddressBookID may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2AddressBookID_count == 0)
                    {
                        theiAP2RecentsList->iAP2AddressBookID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISPLAY_NAME_SPID_2:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2DisplayName may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2DisplayName_count == 0)
                    {
                        theiAP2RecentsList->iAP2DisplayName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DURATION_SPID_8:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Duration may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Duration_count == 0)
                    {
                        theiAP2RecentsList->iAP2Duration_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INDEX_SPID_0:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Index may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Index_count == 0)
                    {
                        theiAP2RecentsList->iAP2Index_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LABEL_SPID_3:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Label may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Label_count == 0)
                    {
                        theiAP2RecentsList->iAP2Label_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_OCCURRENCES_SPID_9:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Occurrences may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Occurrences_count == 0)
                    {
                        theiAP2RecentsList->iAP2Occurrences_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REMOTE_ID_SPID_1:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2RemoteID may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2RemoteID_count == 0)
                    {
                        theiAP2RecentsList->iAP2RemoteID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERVICE_SPID_5:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Service may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Service_count == 0)
                    {
                        theiAP2RecentsList->iAP2Service_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TYPE_SPID_6:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2Type may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Type_count == 0)
                    {
                        theiAP2RecentsList->iAP2Type_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_UNIX_TIMESTAMP_SPID_7:
                {
                    //Check Whether the iOS Device has provided the datafield or not
                    // iAP2UnixTimestamp may occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2UnixTimestamp_count == 0)
                    {
                        theiAP2RecentsList->iAP2UnixTimestamp_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received. ID:%d ", currentID);
                    break;
                }
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }

    }

    if( (theiAP2RecentsList->iAP2AddressBookID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AddressBookID count = %d", theiAP2RecentsList->iAP2AddressBookID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2AddressBookID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2AddressBookID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RecentsList->iAP2DisplayName_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DisplayName count = %d", theiAP2RecentsList->iAP2DisplayName_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2DisplayName,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2DisplayName_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RecentsList->iAP2DisplayName_count = 0");
    }
    if( (theiAP2RecentsList->iAP2Duration_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Duration count = %d", theiAP2RecentsList->iAP2Duration_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2Duration,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2Duration_count,
                                        sizeof(U32),
                                        FALSE);
    }
    if( (theiAP2RecentsList->iAP2Index_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Index count = %d", theiAP2RecentsList->iAP2Index_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2Index,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2Index_count,
                                        sizeof(U16),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RecentsList->iAP2Index_count = 0");
    }
    if( (theiAP2RecentsList->iAP2Label_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Label count = %d", theiAP2RecentsList->iAP2Label_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2Label,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2Label_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    if( (theiAP2RecentsList->iAP2Occurrences_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Occurrences count = %d", theiAP2RecentsList->iAP2Occurrences_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2Occurrences,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2Occurrences_count,
                                        sizeof(U8),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RecentsList->iAP2Occurrences_count = 0");
    }
    if( (theiAP2RecentsList->iAP2RemoteID_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RemoteID count = %d", theiAP2RecentsList->iAP2RemoteID_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2RemoteID,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2RemoteID_count,
                                        sizeof(U8*),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RecentsList->iAP2RemoteID_count = 0");
    }
    if( (theiAP2RecentsList->iAP2Service_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Service count = %d", theiAP2RecentsList->iAP2Service_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2Service,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2Service_count,
                                        sizeof(iAP2ListUpdateService),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RecentsList->iAP2Service_count = 0");
    }
    if( (theiAP2RecentsList->iAP2Type_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2Type count = %d", theiAP2RecentsList->iAP2Type_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2Type,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2Type_count,
                                        sizeof(iAP2ListUpdateRecentsListType),
                                        FALSE);
    }
    else
    {
        rc = IAP2_INVALID_PARAMETER_COUNT;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, " iAP2RecentsList->iAP2Type_count = 0");
    }
    if( (theiAP2RecentsList->iAP2UnixTimestamp_count >= 1) && (rc == IAP2_OK) )
    {
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2UnixTimestamp count = %d", theiAP2RecentsList->iAP2UnixTimestamp_count);
        rc = iAP2AllocateFromBufferPool(&theiAP2RecentsList->iAP2UnixTimestamp,
                                        iAP2BufferPool,
                                        iAP2BufferPool_WrPtr,
                                        &theiAP2RecentsList->iAP2UnixTimestamp_count,
                                        sizeof(U64),
                                        FALSE);
    }

    for(currentPosition = IAP2_PAR_DATA_OFFSET; ( (currentPosition + IAP2_MSG_PARAMETER_HEADER_LENGTH <= parameterLength) && (rc == IAP2_OK) ); currentPosition += currentLength)
    {
        currentLength = iAP2GetIDorLength(&p_SourceBuffer[currentPosition]);
        if(((currentPosition + currentLength) <= parameterLength) && (currentLength != 0))
        {
            currentID     = iAP2GetIDorLength(&p_SourceBuffer[currentPosition + IAP2_ID_OFFSET]);

            switch (currentID)
            {
                case IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4:
                {
                    // iAP2AddressBookID (U8 utf8 [0..1] 4), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2AddressBookID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2AddressBookID[theiAP2RecentsList->iAP2AddressBookID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RecentsList->iAP2AddressBookID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DISPLAY_NAME_SPID_2:
                {
                    // iAP2DisplayName (U8 utf8 [1..1] 2), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2DisplayName_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2DisplayName[theiAP2RecentsList->iAP2DisplayName_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RecentsList->iAP2DisplayName_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_DURATION_SPID_8:
                {
                    // iAP2Duration (U32 secs32 [0..1] 8), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Duration_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2Duration[theiAP2RecentsList->iAP2Duration_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_secs32);
                        theiAP2RecentsList->iAP2Duration_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_INDEX_SPID_0:
                {
                    // iAP2Index (U16 uint16 [1..1] 0), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Index_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2Index[theiAP2RecentsList->iAP2Index_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint16);
                        theiAP2RecentsList->iAP2Index_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_LABEL_SPID_3:
                {
                    // iAP2Label (U8 utf8 [0..1] 3), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Label_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2Label[theiAP2RecentsList->iAP2Label_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RecentsList->iAP2Label_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_OCCURRENCES_SPID_9:
                {
                    // iAP2Occurrences (U8 uint8 [1..1] 9), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Occurrences_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2Occurrences[theiAP2RecentsList->iAP2Occurrences_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint8);
                        theiAP2RecentsList->iAP2Occurrences_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_REMOTE_ID_SPID_1:
                {
                    // iAP2RemoteID (U8 utf8 [1..1] 1), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2RemoteID_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2RemoteID[theiAP2RecentsList->iAP2RemoteID_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_utf8);
                        theiAP2RecentsList->iAP2RemoteID_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_SERVICE_SPID_5:
                {
                    // iAP2Service (iAP2ListUpdateService enum [1..1] 5), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Service_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2Service[theiAP2RecentsList->iAP2Service_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RecentsList->iAP2Service_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_TYPE_SPID_6:
                {
                    // iAP2Type (iAP2ListUpdateRecentsListType enum [1..1] 6), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2Type_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2Type[theiAP2RecentsList->iAP2Type_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_enum);
                        theiAP2RecentsList->iAP2Type_count++;
                    }
                    break;
                }

                case IAP2_PAR_ID_UNIX_TIMESTAMP_SPID_7:
                {
                    // iAP2UnixTimestamp (U64 uint64 [0..1] 7), It may not occur no more than once, all further occurences are ignored
                    if(theiAP2RecentsList->iAP2UnixTimestamp_count == 0)
                    {
                        rc = iAP2GetParam(&theiAP2RecentsList->iAP2UnixTimestamp[theiAP2RecentsList->iAP2UnixTimestamp_count],
                                          &p_SourceBuffer[currentPosition],
                                          currentLength,
                                          iAP2_uint64);
                        theiAP2RecentsList->iAP2UnixTimestamp_count++;
                    }
                    break;
                }

                default:
                {
                    IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Unknown Parameter received ID:%d", currentID);
                    break;
                }

            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "Invalid currentLength %d for parameterLength %d  at Position %d ID:%d", currentLength,parameterLength,currentPosition,currentID);
            return IAP2_INVALID_PARAMETER_LENGTH;
        }
    }
    return rc;
}
